/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class RouteExistsRequest
implements Validatable {
    private final String domainId;
    private final String host;
    private final String path;

    RouteExistsRequest(String domainId, String host, String path) {
        this.domainId = domainId;
        this.host = host;
        this.path = path;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.domainId == null) {
            builder.message("domain id must be specified");
        }
        if (this.host == null) {
            builder.message("host must be specified");
        }
        return builder.build();
    }

    public static RouteExistsRequestBuilder builder() {
        return new RouteExistsRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RouteExistsRequest)) {
            return false;
        }
        RouteExistsRequest other = (RouteExistsRequest)o;
        String this$domainId = this.getDomainId();
        String other$domainId = other.getDomainId();
        if (this$domainId == null ? other$domainId != null : !this$domainId.equals(other$domainId)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $domainId = this.getDomainId();
        result = result * 59 + ($domainId == null ? 43 : $domainId.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    public String toString() {
        return "RouteExistsRequest(domainId=" + this.getDomainId() + ", host=" + this.getHost() + ", path=" + this.getPath() + ")";
    }

    @JsonIgnore
    public String getDomainId() {
        return this.domainId;
    }

    @JsonIgnore
    public String getHost() {
        return this.host;
    }

    @QueryParameter(value="path")
    public String getPath() {
        return this.path;
    }

    public static class RouteExistsRequestBuilder {
        private String domainId;
        private String host;
        private String path;

        RouteExistsRequestBuilder() {
        }

        public RouteExistsRequestBuilder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public RouteExistsRequestBuilder host(String host) {
            this.host = host;
            return this;
        }

        public RouteExistsRequestBuilder path(String path) {
            this.path = path;
            return this;
        }

        public RouteExistsRequest build() {
            return new RouteExistsRequest(this.domainId, this.host, this.path);
        }

        public String toString() {
            return "RouteExistsRequest.RouteExistsRequestBuilder(domainId=" + this.domainId + ", host=" + this.host + ", path=" + this.path + ")";
        }
    }
}

