/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class UpdateRouteRequest
implements Validatable {
    private final String domainId;
    private final String host;
    private final String path;
    private final Integer port;
    private final String routeId;
    private final String spaceId;

    UpdateRouteRequest(String domainId, String host, String path, Integer port, String routeId, String spaceId) {
        this.domainId = domainId;
        this.host = host;
        this.path = path;
        this.port = port;
        this.routeId = routeId;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.routeId == null) {
            builder.message("route id must be specified");
        }
        return builder.build();
    }

    public static UpdateRouteRequestBuilder builder() {
        return new UpdateRouteRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateRouteRequest)) {
            return false;
        }
        UpdateRouteRequest other = (UpdateRouteRequest)o;
        String this$domainId = this.getDomainId();
        String other$domainId = other.getDomainId();
        if (this$domainId == null ? other$domainId != null : !this$domainId.equals(other$domainId)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$routeId = this.getRouteId();
        String other$routeId = other.getRouteId();
        if (this$routeId == null ? other$routeId != null : !this$routeId.equals(other$routeId)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        return !(this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $domainId = this.getDomainId();
        result = result * 59 + ($domainId == null ? 43 : $domainId.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $routeId = this.getRouteId();
        result = result * 59 + ($routeId == null ? 43 : $routeId.hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    public String toString() {
        return "UpdateRouteRequest(domainId=" + this.getDomainId() + ", host=" + this.getHost() + ", path=" + this.getPath() + ", port=" + this.getPort() + ", routeId=" + this.getRouteId() + ", spaceId=" + this.getSpaceId() + ")";
    }

    @JsonProperty(value="domain_guid")
    public String getDomainId() {
        return this.domainId;
    }

    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="port")
    public Integer getPort() {
        return this.port;
    }

    @JsonIgnore
    public String getRouteId() {
        return this.routeId;
    }

    @JsonProperty(value="space_guid")
    public String getSpaceId() {
        return this.spaceId;
    }

    public static class UpdateRouteRequestBuilder {
        private String domainId;
        private String host;
        private String path;
        private Integer port;
        private String routeId;
        private String spaceId;

        UpdateRouteRequestBuilder() {
        }

        public UpdateRouteRequestBuilder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public UpdateRouteRequestBuilder host(String host) {
            this.host = host;
            return this;
        }

        public UpdateRouteRequestBuilder path(String path) {
            this.path = path;
            return this;
        }

        public UpdateRouteRequestBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public UpdateRouteRequestBuilder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public UpdateRouteRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public UpdateRouteRequest build() {
            return new UpdateRouteRequest(this.domainId, this.host, this.path, this.port, this.routeId, this.spaceId);
        }

        public String toString() {
            return "UpdateRouteRequest.UpdateRouteRequestBuilder(domainId=" + this.domainId + ", host=" + this.host + ", path=" + this.path + ", port=" + this.port + ", routeId=" + this.routeId + ", spaceId=" + this.spaceId + ")";
        }
    }
}

