/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.securitygroups;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.securitygroups.SecurityGroupResource;

public final class ListSecurityGroupStagingDefaultsResponse
extends PaginatedResponse<SecurityGroupResource> {
    ListSecurityGroupStagingDefaultsResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<SecurityGroupResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListSecurityGroupStagingDefaultsResponseBuilder builder() {
        return new ListSecurityGroupStagingDefaultsResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListSecurityGroupStagingDefaultsResponse)) {
            return false;
        }
        ListSecurityGroupStagingDefaultsResponse other = (ListSecurityGroupStagingDefaultsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListSecurityGroupStagingDefaultsResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListSecurityGroupStagingDefaultsResponse(super=" + super.toString() + ")";
    }

    public static class ListSecurityGroupStagingDefaultsResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<SecurityGroupResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListSecurityGroupStagingDefaultsResponseBuilder() {
        }

        public ListSecurityGroupStagingDefaultsResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListSecurityGroupStagingDefaultsResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListSecurityGroupStagingDefaultsResponseBuilder resource(SecurityGroupResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListSecurityGroupStagingDefaultsResponseBuilder resources(Collection<? extends SecurityGroupResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListSecurityGroupStagingDefaultsResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListSecurityGroupStagingDefaultsResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListSecurityGroupStagingDefaultsResponse build() {
            List<SecurityGroupResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<SecurityGroupResource>(this.resources));
                }
            }
            return new ListSecurityGroupStagingDefaultsResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListSecurityGroupStagingDefaultsResponse.ListSecurityGroupStagingDefaultsResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

