/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.securitygroups;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class SecurityGroupEntity {
    private final String name;
    private final List<RuleEntity> rules;
    private final Boolean runningDefault;
    private final String spacesUrl;
    private final Boolean stagingDefault;

    SecurityGroupEntity(@JsonProperty(value="name") String name, @JsonProperty(value="rules") List<RuleEntity> rules, @JsonProperty(value="running_default") Boolean runningDefault, @JsonProperty(value="spaces_url") String spacesUrl, @JsonProperty(value="staging_default") Boolean stagingDefault) {
        this.name = name;
        this.rules = Optional.ofNullable(rules).orElse(Collections.emptyList());
        this.runningDefault = runningDefault;
        this.spacesUrl = spacesUrl;
        this.stagingDefault = stagingDefault;
    }

    public static SecurityGroupEntityBuilder builder() {
        return new SecurityGroupEntityBuilder();
    }

    public String getName() {
        return this.name;
    }

    public List<RuleEntity> getRules() {
        return this.rules;
    }

    public Boolean getRunningDefault() {
        return this.runningDefault;
    }

    public String getSpacesUrl() {
        return this.spacesUrl;
    }

    public Boolean getStagingDefault() {
        return this.stagingDefault;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityGroupEntity)) {
            return false;
        }
        SecurityGroupEntity other = (SecurityGroupEntity)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<RuleEntity> this$rules = this.getRules();
        List<RuleEntity> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        Boolean this$runningDefault = this.getRunningDefault();
        Boolean other$runningDefault = other.getRunningDefault();
        if (this$runningDefault == null ? other$runningDefault != null : !((Object)this$runningDefault).equals(other$runningDefault)) {
            return false;
        }
        String this$spacesUrl = this.getSpacesUrl();
        String other$spacesUrl = other.getSpacesUrl();
        if (this$spacesUrl == null ? other$spacesUrl != null : !this$spacesUrl.equals(other$spacesUrl)) {
            return false;
        }
        Boolean this$stagingDefault = this.getStagingDefault();
        Boolean other$stagingDefault = other.getStagingDefault();
        return !(this$stagingDefault == null ? other$stagingDefault != null : !((Object)this$stagingDefault).equals(other$stagingDefault));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<RuleEntity> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        Boolean $runningDefault = this.getRunningDefault();
        result = result * 59 + ($runningDefault == null ? 43 : ((Object)$runningDefault).hashCode());
        String $spacesUrl = this.getSpacesUrl();
        result = result * 59 + ($spacesUrl == null ? 43 : $spacesUrl.hashCode());
        Boolean $stagingDefault = this.getStagingDefault();
        result = result * 59 + ($stagingDefault == null ? 43 : ((Object)$stagingDefault).hashCode());
        return result;
    }

    public String toString() {
        return "SecurityGroupEntity(name=" + this.getName() + ", rules=" + this.getRules() + ", runningDefault=" + this.getRunningDefault() + ", spacesUrl=" + this.getSpacesUrl() + ", stagingDefault=" + this.getStagingDefault() + ")";
    }

    public static class SecurityGroupEntityBuilder {
        private String name;
        private ArrayList<RuleEntity> rules;
        private Boolean runningDefault;
        private String spacesUrl;
        private Boolean stagingDefault;

        SecurityGroupEntityBuilder() {
        }

        public SecurityGroupEntityBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SecurityGroupEntityBuilder rule(RuleEntity rule) {
            if (this.rules == null) {
                this.rules = new ArrayList();
            }
            this.rules.add(rule);
            return this;
        }

        public SecurityGroupEntityBuilder rules(Collection<? extends RuleEntity> rules) {
            if (this.rules == null) {
                this.rules = new ArrayList();
            }
            this.rules.addAll(rules);
            return this;
        }

        public SecurityGroupEntityBuilder runningDefault(Boolean runningDefault) {
            this.runningDefault = runningDefault;
            return this;
        }

        public SecurityGroupEntityBuilder spacesUrl(String spacesUrl) {
            this.spacesUrl = spacesUrl;
            return this;
        }

        public SecurityGroupEntityBuilder stagingDefault(Boolean stagingDefault) {
            this.stagingDefault = stagingDefault;
            return this;
        }

        public SecurityGroupEntity build() {
            List<RuleEntity> rules;
            switch (this.rules == null ? 0 : this.rules.size()) {
                case 0: {
                    rules = Collections.emptyList();
                    break;
                }
                case 1: {
                    rules = Collections.singletonList(this.rules.get(0));
                    break;
                }
                default: {
                    rules = Collections.unmodifiableList(new ArrayList<RuleEntity>(this.rules));
                }
            }
            return new SecurityGroupEntity(this.name, rules, this.runningDefault, this.spacesUrl, this.stagingDefault);
        }

        public String toString() {
            return "SecurityGroupEntity.SecurityGroupEntityBuilder(name=" + this.name + ", rules=" + this.rules + ", runningDefault=" + this.runningDefault + ", spacesUrl=" + this.spacesUrl + ", stagingDefault=" + this.stagingDefault + ")";
        }
    }

    public static final class RuleEntity {
        private final String destination;
        private final String ports;
        private final String protocol;

        RuleEntity(@JsonProperty(value="destination") String destination, @JsonProperty(value="ports") String ports, @JsonProperty(value="protocol") String protocol) {
            this.destination = destination;
            this.ports = ports;
            this.protocol = protocol;
        }

        public static RuleEntityBuilder builder() {
            return new RuleEntityBuilder();
        }

        public String getDestination() {
            return this.destination;
        }

        public String getPorts() {
            return this.ports;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RuleEntity)) {
                return false;
            }
            RuleEntity other = (RuleEntity)o;
            String this$destination = this.getDestination();
            String other$destination = other.getDestination();
            if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
                return false;
            }
            String this$ports = this.getPorts();
            String other$ports = other.getPorts();
            if (this$ports == null ? other$ports != null : !this$ports.equals(other$ports)) {
                return false;
            }
            String this$protocol = this.getProtocol();
            String other$protocol = other.getProtocol();
            return !(this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
            String $ports = this.getPorts();
            result = result * 59 + ($ports == null ? 43 : $ports.hashCode());
            String $protocol = this.getProtocol();
            result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
            return result;
        }

        public String toString() {
            return "SecurityGroupEntity.RuleEntity(destination=" + this.getDestination() + ", ports=" + this.getPorts() + ", protocol=" + this.getProtocol() + ")";
        }

        public static class RuleEntityBuilder {
            private String destination;
            private String ports;
            private String protocol;

            RuleEntityBuilder() {
            }

            public RuleEntityBuilder destination(String destination) {
                this.destination = destination;
                return this;
            }

            public RuleEntityBuilder ports(String ports) {
                this.ports = ports;
                return this;
            }

            public RuleEntityBuilder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public RuleEntity build() {
                return new RuleEntity(this.destination, this.ports, this.protocol);
            }

            public String toString() {
                return "SecurityGroupEntity.RuleEntity.RuleEntityBuilder(destination=" + this.destination + ", ports=" + this.ports + ", protocol=" + this.protocol + ")";
            }
        }
    }
}

