/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicebindings;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CreateServiceBindingRequest
implements Validatable {
    private final String applicationId;
    private final Map<String, Object> parameters;
    private final String serviceInstanceId;

    CreateServiceBindingRequest(String applicationId, String serviceInstanceId, Map<String, Object> parameters) {
        this.applicationId = applicationId;
        this.serviceInstanceId = serviceInstanceId;
        this.parameters = parameters;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.serviceInstanceId == null) {
            builder.message("service instance id must be specified");
        }
        return builder.build();
    }

    public static CreateServiceBindingRequestBuilder builder() {
        return new CreateServiceBindingRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateServiceBindingRequest)) {
            return false;
        }
        CreateServiceBindingRequest other = (CreateServiceBindingRequest)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        Map<String, Object> this$parameters = this.getParameters();
        Map<String, Object> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$serviceInstanceId = this.getServiceInstanceId();
        String other$serviceInstanceId = other.getServiceInstanceId();
        return !(this$serviceInstanceId == null ? other$serviceInstanceId != null : !this$serviceInstanceId.equals(other$serviceInstanceId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        Map<String, Object> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $serviceInstanceId = this.getServiceInstanceId();
        result = result * 59 + ($serviceInstanceId == null ? 43 : $serviceInstanceId.hashCode());
        return result;
    }

    public String toString() {
        return "CreateServiceBindingRequest(applicationId=" + this.getApplicationId() + ", parameters=" + this.getParameters() + ", serviceInstanceId=" + this.getServiceInstanceId() + ")";
    }

    @JsonProperty(value="app_guid")
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="service_instance_guid")
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public static class CreateServiceBindingRequestBuilder {
        private String applicationId;
        private String serviceInstanceId;
        private ArrayList<String> parameters$key;
        private ArrayList<Object> parameters$value;

        CreateServiceBindingRequestBuilder() {
        }

        public CreateServiceBindingRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public CreateServiceBindingRequestBuilder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public CreateServiceBindingRequestBuilder parameter(String parameterKey, Object parameterValue) {
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            this.parameters$key.add(parameterKey);
            this.parameters$value.add(parameterValue);
            return this;
        }

        public CreateServiceBindingRequestBuilder parameters(Map<? extends String, ? extends Object> parameters) {
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : parameters.entrySet()) {
                this.parameters$key.add($lombokEntry.getKey());
                this.parameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CreateServiceBindingRequest build() {
            Map<String, Object> parameters;
            switch (this.parameters$key == null ? 0 : this.parameters$key.size()) {
                case 0: {
                    parameters = Collections.emptyMap();
                    break;
                }
                case 1: {
                    parameters = Collections.singletonMap(this.parameters$key.get(0), this.parameters$value.get(0));
                    break;
                }
                default: {
                    parameters = new LinkedHashMap(this.parameters$key.size() < 0x40000000 ? 1 + this.parameters$key.size() + (this.parameters$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.parameters$key.size(); ++$i) {
                        parameters.put(this.parameters$key.get($i), this.parameters$value.get($i));
                    }
                    parameters = Collections.unmodifiableMap(parameters);
                }
            }
            return new CreateServiceBindingRequest(this.applicationId, this.serviceInstanceId, parameters);
        }

        public String toString() {
            return "CreateServiceBindingRequest.CreateServiceBindingRequestBuilder(applicationId=" + this.applicationId + ", serviceInstanceId=" + this.serviceInstanceId + ", parameters$key=" + this.parameters$key + ", parameters$value=" + this.parameters$value + ")";
        }
    }
}

