/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicebindings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListServiceBindingsRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> applicationIds;
    private final List<String> serviceInstanceIds;

    ListServiceBindingsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> applicationIds, List<String> serviceInstanceIds) {
        super(orderDirection, page, resultsPerPage);
        this.applicationIds = applicationIds;
        this.serviceInstanceIds = serviceInstanceIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    public static ListServiceBindingsRequestBuilder builder() {
        return new ListServiceBindingsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListServiceBindingsRequest)) {
            return false;
        }
        ListServiceBindingsRequest other = (ListServiceBindingsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$applicationIds = this.getApplicationIds();
        List<String> other$applicationIds = other.getApplicationIds();
        if (this$applicationIds == null ? other$applicationIds != null : !((Object)this$applicationIds).equals(other$applicationIds)) {
            return false;
        }
        List<String> this$serviceInstanceIds = this.getServiceInstanceIds();
        List<String> other$serviceInstanceIds = other.getServiceInstanceIds();
        return !(this$serviceInstanceIds == null ? other$serviceInstanceIds != null : !((Object)this$serviceInstanceIds).equals(other$serviceInstanceIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListServiceBindingsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $applicationIds = this.getApplicationIds();
        result = result * 59 + ($applicationIds == null ? 43 : ((Object)$applicationIds).hashCode());
        List<String> $serviceInstanceIds = this.getServiceInstanceIds();
        result = result * 59 + ($serviceInstanceIds == null ? 43 : ((Object)$serviceInstanceIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListServiceBindingsRequest(super=" + super.toString() + ", applicationIds=" + this.getApplicationIds() + ", serviceInstanceIds=" + this.getServiceInstanceIds() + ")";
    }

    @InFilterParameter(value="app_guid")
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @InFilterParameter(value="service_instance_guid")
    public List<String> getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }

    public static class ListServiceBindingsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> applicationIds;
        private ArrayList<String> serviceInstanceIds;

        ListServiceBindingsRequestBuilder() {
        }

        public ListServiceBindingsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListServiceBindingsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListServiceBindingsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListServiceBindingsRequestBuilder applicationId(String applicationId) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList();
            }
            this.applicationIds.add(applicationId);
            return this;
        }

        public ListServiceBindingsRequestBuilder applicationIds(Collection<? extends String> applicationIds) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList();
            }
            this.applicationIds.addAll(applicationIds);
            return this;
        }

        public ListServiceBindingsRequestBuilder serviceInstanceId(String serviceInstanceId) {
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList();
            }
            this.serviceInstanceIds.add(serviceInstanceId);
            return this;
        }

        public ListServiceBindingsRequestBuilder serviceInstanceIds(Collection<? extends String> serviceInstanceIds) {
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList();
            }
            this.serviceInstanceIds.addAll(serviceInstanceIds);
            return this;
        }

        public ListServiceBindingsRequest build() {
            List<String> serviceInstanceIds;
            List<String> applicationIds;
            switch (this.applicationIds == null ? 0 : this.applicationIds.size()) {
                case 0: {
                    applicationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    applicationIds = Collections.singletonList(this.applicationIds.get(0));
                    break;
                }
                default: {
                    applicationIds = Collections.unmodifiableList(new ArrayList<String>(this.applicationIds));
                }
            }
            switch (this.serviceInstanceIds == null ? 0 : this.serviceInstanceIds.size()) {
                case 0: {
                    serviceInstanceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceInstanceIds = Collections.singletonList(this.serviceInstanceIds.get(0));
                    break;
                }
                default: {
                    serviceInstanceIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceInstanceIds));
                }
            }
            return new ListServiceBindingsRequest(this.orderDirection, this.page, this.resultsPerPage, applicationIds, serviceInstanceIds);
        }

        public String toString() {
            return "ListServiceBindingsRequest.ListServiceBindingsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", applicationIds=" + this.applicationIds + ", serviceInstanceIds=" + this.serviceInstanceIds + ")";
        }
    }
}

