/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicebindings;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public final class ServiceBindingEntity {
    private final String applicationId;
    private final String applicationUrl;
    private final Map<String, Object> bindingOptions;
    private final Map<String, Object> credentials;
    private final Map<String, Object> gatewayData;
    private final String gatewayName;
    private final String serviceInstanceId;
    private final String serviceInstanceUrl;
    private final String syslogDrainUrl;

    ServiceBindingEntity(@JsonProperty(value="app_guid") String applicationId, @JsonProperty(value="app_url") String applicationUrl, @JsonProperty(value="binding_options") Map<String, Object> bindingOptions, @JsonProperty(value="credentials") Map<String, Object> credentials, @JsonProperty(value="gateway_data") Map<String, Object> gatewayData, @JsonProperty(value="gateway_name") String gatewayName, @JsonProperty(value="service_instance_guid") String serviceInstanceId, @JsonProperty(value="service_instance_url") String serviceInstanceUrl, @JsonProperty(value="syslog_drain_url") String syslogDrainUrl) {
        this.applicationId = applicationId;
        this.applicationUrl = applicationUrl;
        this.bindingOptions = Optional.ofNullable(bindingOptions).orElse(Collections.emptyMap());
        this.credentials = Optional.ofNullable(credentials).orElse(Collections.emptyMap());
        this.gatewayData = gatewayData;
        this.gatewayName = gatewayName;
        this.serviceInstanceId = serviceInstanceId;
        this.serviceInstanceUrl = serviceInstanceUrl;
        this.syslogDrainUrl = syslogDrainUrl;
    }

    public static ServiceBindingEntityBuilder builder() {
        return new ServiceBindingEntityBuilder();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationUrl() {
        return this.applicationUrl;
    }

    public Map<String, Object> getBindingOptions() {
        return this.bindingOptions;
    }

    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    public Map<String, Object> getGatewayData() {
        return this.gatewayData;
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public String getServiceInstanceUrl() {
        return this.serviceInstanceUrl;
    }

    public String getSyslogDrainUrl() {
        return this.syslogDrainUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceBindingEntity)) {
            return false;
        }
        ServiceBindingEntity other = (ServiceBindingEntity)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$applicationUrl = this.getApplicationUrl();
        String other$applicationUrl = other.getApplicationUrl();
        if (this$applicationUrl == null ? other$applicationUrl != null : !this$applicationUrl.equals(other$applicationUrl)) {
            return false;
        }
        Map<String, Object> this$bindingOptions = this.getBindingOptions();
        Map<String, Object> other$bindingOptions = other.getBindingOptions();
        if (this$bindingOptions == null ? other$bindingOptions != null : !((Object)this$bindingOptions).equals(other$bindingOptions)) {
            return false;
        }
        Map<String, Object> this$credentials = this.getCredentials();
        Map<String, Object> other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials)) {
            return false;
        }
        Map<String, Object> this$gatewayData = this.getGatewayData();
        Map<String, Object> other$gatewayData = other.getGatewayData();
        if (this$gatewayData == null ? other$gatewayData != null : !((Object)this$gatewayData).equals(other$gatewayData)) {
            return false;
        }
        String this$gatewayName = this.getGatewayName();
        String other$gatewayName = other.getGatewayName();
        if (this$gatewayName == null ? other$gatewayName != null : !this$gatewayName.equals(other$gatewayName)) {
            return false;
        }
        String this$serviceInstanceId = this.getServiceInstanceId();
        String other$serviceInstanceId = other.getServiceInstanceId();
        if (this$serviceInstanceId == null ? other$serviceInstanceId != null : !this$serviceInstanceId.equals(other$serviceInstanceId)) {
            return false;
        }
        String this$serviceInstanceUrl = this.getServiceInstanceUrl();
        String other$serviceInstanceUrl = other.getServiceInstanceUrl();
        if (this$serviceInstanceUrl == null ? other$serviceInstanceUrl != null : !this$serviceInstanceUrl.equals(other$serviceInstanceUrl)) {
            return false;
        }
        String this$syslogDrainUrl = this.getSyslogDrainUrl();
        String other$syslogDrainUrl = other.getSyslogDrainUrl();
        return !(this$syslogDrainUrl == null ? other$syslogDrainUrl != null : !this$syslogDrainUrl.equals(other$syslogDrainUrl));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $applicationUrl = this.getApplicationUrl();
        result = result * 59 + ($applicationUrl == null ? 43 : $applicationUrl.hashCode());
        Map<String, Object> $bindingOptions = this.getBindingOptions();
        result = result * 59 + ($bindingOptions == null ? 43 : ((Object)$bindingOptions).hashCode());
        Map<String, Object> $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
        Map<String, Object> $gatewayData = this.getGatewayData();
        result = result * 59 + ($gatewayData == null ? 43 : ((Object)$gatewayData).hashCode());
        String $gatewayName = this.getGatewayName();
        result = result * 59 + ($gatewayName == null ? 43 : $gatewayName.hashCode());
        String $serviceInstanceId = this.getServiceInstanceId();
        result = result * 59 + ($serviceInstanceId == null ? 43 : $serviceInstanceId.hashCode());
        String $serviceInstanceUrl = this.getServiceInstanceUrl();
        result = result * 59 + ($serviceInstanceUrl == null ? 43 : $serviceInstanceUrl.hashCode());
        String $syslogDrainUrl = this.getSyslogDrainUrl();
        result = result * 59 + ($syslogDrainUrl == null ? 43 : $syslogDrainUrl.hashCode());
        return result;
    }

    public String toString() {
        return "ServiceBindingEntity(applicationId=" + this.getApplicationId() + ", applicationUrl=" + this.getApplicationUrl() + ", bindingOptions=" + this.getBindingOptions() + ", credentials=" + this.getCredentials() + ", gatewayData=" + this.getGatewayData() + ", gatewayName=" + this.getGatewayName() + ", serviceInstanceId=" + this.getServiceInstanceId() + ", serviceInstanceUrl=" + this.getServiceInstanceUrl() + ", syslogDrainUrl=" + this.getSyslogDrainUrl() + ")";
    }

    public static class ServiceBindingEntityBuilder {
        private String applicationId;
        private String applicationUrl;
        private ArrayList<String> bindingOptions$key;
        private ArrayList<Object> bindingOptions$value;
        private ArrayList<String> credentials$key;
        private ArrayList<Object> credentials$value;
        private Map<String, Object> gatewayData;
        private String gatewayName;
        private String serviceInstanceId;
        private String serviceInstanceUrl;
        private String syslogDrainUrl;

        ServiceBindingEntityBuilder() {
        }

        public ServiceBindingEntityBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public ServiceBindingEntityBuilder applicationUrl(String applicationUrl) {
            this.applicationUrl = applicationUrl;
            return this;
        }

        public ServiceBindingEntityBuilder bindingOption(String bindingOptionKey, Object bindingOptionValue) {
            if (this.bindingOptions$key == null) {
                this.bindingOptions$key = new ArrayList();
                this.bindingOptions$value = new ArrayList();
            }
            this.bindingOptions$key.add(bindingOptionKey);
            this.bindingOptions$value.add(bindingOptionValue);
            return this;
        }

        public ServiceBindingEntityBuilder bindingOptions(Map<? extends String, ? extends Object> bindingOptions) {
            if (this.bindingOptions$key == null) {
                this.bindingOptions$key = new ArrayList();
                this.bindingOptions$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : bindingOptions.entrySet()) {
                this.bindingOptions$key.add($lombokEntry.getKey());
                this.bindingOptions$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ServiceBindingEntityBuilder credential(String credentialKey, Object credentialValue) {
            if (this.credentials$key == null) {
                this.credentials$key = new ArrayList();
                this.credentials$value = new ArrayList();
            }
            this.credentials$key.add(credentialKey);
            this.credentials$value.add(credentialValue);
            return this;
        }

        public ServiceBindingEntityBuilder credentials(Map<? extends String, ? extends Object> credentials) {
            if (this.credentials$key == null) {
                this.credentials$key = new ArrayList();
                this.credentials$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : credentials.entrySet()) {
                this.credentials$key.add($lombokEntry.getKey());
                this.credentials$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ServiceBindingEntityBuilder gatewayData(Map<String, Object> gatewayData) {
            this.gatewayData = gatewayData;
            return this;
        }

        public ServiceBindingEntityBuilder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public ServiceBindingEntityBuilder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public ServiceBindingEntityBuilder serviceInstanceUrl(String serviceInstanceUrl) {
            this.serviceInstanceUrl = serviceInstanceUrl;
            return this;
        }

        public ServiceBindingEntityBuilder syslogDrainUrl(String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
            return this;
        }

        public ServiceBindingEntity build() {
            Map<String, Object> credentials;
            Map<Object, Object> bindingOptions;
            switch (this.bindingOptions$key == null ? 0 : this.bindingOptions$key.size()) {
                case 0: {
                    bindingOptions = Collections.emptyMap();
                    break;
                }
                case 1: {
                    bindingOptions = Collections.singletonMap(this.bindingOptions$key.get(0), this.bindingOptions$value.get(0));
                    break;
                }
                default: {
                    bindingOptions = new LinkedHashMap(this.bindingOptions$key.size() < 0x40000000 ? 1 + this.bindingOptions$key.size() + (this.bindingOptions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.bindingOptions$key.size(); ++$i) {
                        bindingOptions.put(this.bindingOptions$key.get($i), this.bindingOptions$value.get($i));
                    }
                    bindingOptions = Collections.unmodifiableMap(bindingOptions);
                }
            }
            switch (this.credentials$key == null ? 0 : this.credentials$key.size()) {
                case 0: {
                    credentials = Collections.emptyMap();
                    break;
                }
                case 1: {
                    credentials = Collections.singletonMap(this.credentials$key.get(0), this.credentials$value.get(0));
                    break;
                }
                default: {
                    credentials = new LinkedHashMap(this.credentials$key.size() < 0x40000000 ? 1 + this.credentials$key.size() + (this.credentials$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.credentials$key.size(); ++$i) {
                        credentials.put(this.credentials$key.get($i), this.credentials$value.get($i));
                    }
                    credentials = Collections.unmodifiableMap(credentials);
                }
            }
            return new ServiceBindingEntity(this.applicationId, this.applicationUrl, bindingOptions, credentials, this.gatewayData, this.gatewayName, this.serviceInstanceId, this.serviceInstanceUrl, this.syslogDrainUrl);
        }

        public String toString() {
            return "ServiceBindingEntity.ServiceBindingEntityBuilder(applicationId=" + this.applicationId + ", applicationUrl=" + this.applicationUrl + ", bindingOptions$key=" + this.bindingOptions$key + ", bindingOptions$value=" + this.bindingOptions$value + ", credentials$key=" + this.credentials$key + ", credentials$value=" + this.credentials$value + ", gatewayData=" + this.gatewayData + ", gatewayName=" + this.gatewayName + ", serviceInstanceId=" + this.serviceInstanceId + ", serviceInstanceUrl=" + this.serviceInstanceUrl + ", syslogDrainUrl=" + this.syslogDrainUrl + ")";
        }
    }
}

