/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicebrokers;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CreateServiceBrokerRequest
implements Validatable {
    private final String authenticationPassword;
    private final String authenticationUsername;
    private final String brokerUrl;
    private final String name;
    private final String spaceId;

    CreateServiceBrokerRequest(String authenticationPassword, String authenticationUsername, String brokerUrl, String name, String spaceId) {
        this.authenticationPassword = authenticationPassword;
        this.authenticationUsername = authenticationUsername;
        this.brokerUrl = brokerUrl;
        this.name = name;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if (this.authenticationUsername == null) {
            builder.message("authentication username must be specified");
        }
        if (this.authenticationPassword == null) {
            builder.message("authentication password must be specified");
        }
        if (this.brokerUrl == null) {
            builder.message("broker url must be specified");
        }
        return builder.build();
    }

    public static CreateServiceBrokerRequestBuilder builder() {
        return new CreateServiceBrokerRequestBuilder();
    }

    @JsonProperty(value="auth_password")
    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    @JsonProperty(value="auth_username")
    public String getAuthenticationUsername() {
        return this.authenticationUsername;
    }

    @JsonProperty(value="broker_url")
    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="space_guid")
    public String getSpaceId() {
        return this.spaceId;
    }

    public static class CreateServiceBrokerRequestBuilder {
        private String authenticationPassword;
        private String authenticationUsername;
        private String brokerUrl;
        private String name;
        private String spaceId;

        CreateServiceBrokerRequestBuilder() {
        }

        public CreateServiceBrokerRequestBuilder authenticationPassword(String authenticationPassword) {
            this.authenticationPassword = authenticationPassword;
            return this;
        }

        public CreateServiceBrokerRequestBuilder authenticationUsername(String authenticationUsername) {
            this.authenticationUsername = authenticationUsername;
            return this;
        }

        public CreateServiceBrokerRequestBuilder brokerUrl(String brokerUrl) {
            this.brokerUrl = brokerUrl;
            return this;
        }

        public CreateServiceBrokerRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateServiceBrokerRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public CreateServiceBrokerRequest build() {
            return new CreateServiceBrokerRequest(this.authenticationPassword, this.authenticationUsername, this.brokerUrl, this.name, this.spaceId);
        }

        public String toString() {
            return "CreateServiceBrokerRequest.CreateServiceBrokerRequestBuilder(authenticationPassword=" + this.authenticationPassword + ", authenticationUsername=" + this.authenticationUsername + ", brokerUrl=" + this.brokerUrl + ", name=" + this.name + ", spaceId=" + this.spaceId + ")";
        }
    }
}

