/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicebrokers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class DeleteServiceBrokerRequest
implements Validatable {
    private final String serviceBrokerId;

    DeleteServiceBrokerRequest(String serviceBrokerId) {
        this.serviceBrokerId = serviceBrokerId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceBrokerId == null) {
            builder.message("service broker id must be specified");
        }
        return builder.build();
    }

    public static DeleteServiceBrokerRequestBuilder builder() {
        return new DeleteServiceBrokerRequestBuilder();
    }

    @JsonIgnore
    public String getServiceBrokerId() {
        return this.serviceBrokerId;
    }

    public static class DeleteServiceBrokerRequestBuilder {
        private String serviceBrokerId;

        DeleteServiceBrokerRequestBuilder() {
        }

        public DeleteServiceBrokerRequestBuilder serviceBrokerId(String serviceBrokerId) {
            this.serviceBrokerId = serviceBrokerId;
            return this;
        }

        public DeleteServiceBrokerRequest build() {
            return new DeleteServiceBrokerRequest(this.serviceBrokerId);
        }

        public String toString() {
            return "DeleteServiceBrokerRequest.DeleteServiceBrokerRequestBuilder(serviceBrokerId=" + this.serviceBrokerId + ")";
        }
    }
}

