/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicebrokers;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.servicebrokers.ServiceBrokerResource;

public final class ListServiceBrokersResponse
extends PaginatedResponse<ServiceBrokerResource> {
    ListServiceBrokersResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<ServiceBrokerResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListServiceBrokersResponseBuilder builder() {
        return new ListServiceBrokersResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListServiceBrokersResponse)) {
            return false;
        }
        ListServiceBrokersResponse other = (ListServiceBrokersResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListServiceBrokersResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListServiceBrokersResponse(super=" + super.toString() + ")";
    }

    public static class ListServiceBrokersResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<ServiceBrokerResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListServiceBrokersResponseBuilder() {
        }

        public ListServiceBrokersResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListServiceBrokersResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListServiceBrokersResponseBuilder resource(ServiceBrokerResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListServiceBrokersResponseBuilder resources(Collection<? extends ServiceBrokerResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListServiceBrokersResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListServiceBrokersResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListServiceBrokersResponse build() {
            List<ServiceBrokerResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<ServiceBrokerResource>(this.resources));
                }
            }
            return new ListServiceBrokersResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListServiceBrokersResponse.ListServiceBrokersResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

