/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicebrokers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class UpdateServiceBrokerRequest
implements Validatable {
    private final String authenticationPassword;
    private final String authenticationUsername;
    private final String brokerUrl;
    private final String name;
    private final String serviceBrokerId;

    UpdateServiceBrokerRequest(String authenticationPassword, String authenticationUsername, String brokerUrl, String name, String serviceBrokerId) {
        this.authenticationPassword = authenticationPassword;
        this.authenticationUsername = authenticationUsername;
        this.brokerUrl = brokerUrl;
        this.serviceBrokerId = serviceBrokerId;
        this.name = name;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceBrokerId == null) {
            builder.message("service broker id must be specified");
        }
        return builder.build();
    }

    public static UpdateServiceBrokerRequestBuilder builder() {
        return new UpdateServiceBrokerRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateServiceBrokerRequest)) {
            return false;
        }
        UpdateServiceBrokerRequest other = (UpdateServiceBrokerRequest)o;
        String this$authenticationPassword = this.getAuthenticationPassword();
        String other$authenticationPassword = other.getAuthenticationPassword();
        if (this$authenticationPassword == null ? other$authenticationPassword != null : !this$authenticationPassword.equals(other$authenticationPassword)) {
            return false;
        }
        String this$authenticationUsername = this.getAuthenticationUsername();
        String other$authenticationUsername = other.getAuthenticationUsername();
        if (this$authenticationUsername == null ? other$authenticationUsername != null : !this$authenticationUsername.equals(other$authenticationUsername)) {
            return false;
        }
        String this$brokerUrl = this.getBrokerUrl();
        String other$brokerUrl = other.getBrokerUrl();
        if (this$brokerUrl == null ? other$brokerUrl != null : !this$brokerUrl.equals(other$brokerUrl)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$serviceBrokerId = this.getServiceBrokerId();
        String other$serviceBrokerId = other.getServiceBrokerId();
        return !(this$serviceBrokerId == null ? other$serviceBrokerId != null : !this$serviceBrokerId.equals(other$serviceBrokerId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $authenticationPassword = this.getAuthenticationPassword();
        result = result * 59 + ($authenticationPassword == null ? 43 : $authenticationPassword.hashCode());
        String $authenticationUsername = this.getAuthenticationUsername();
        result = result * 59 + ($authenticationUsername == null ? 43 : $authenticationUsername.hashCode());
        String $brokerUrl = this.getBrokerUrl();
        result = result * 59 + ($brokerUrl == null ? 43 : $brokerUrl.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $serviceBrokerId = this.getServiceBrokerId();
        result = result * 59 + ($serviceBrokerId == null ? 43 : $serviceBrokerId.hashCode());
        return result;
    }

    public String toString() {
        return "UpdateServiceBrokerRequest(authenticationPassword=" + this.getAuthenticationPassword() + ", authenticationUsername=" + this.getAuthenticationUsername() + ", brokerUrl=" + this.getBrokerUrl() + ", name=" + this.getName() + ", serviceBrokerId=" + this.getServiceBrokerId() + ")";
    }

    @JsonProperty(value="auth_password")
    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    @JsonProperty(value="auth_username")
    public String getAuthenticationUsername() {
        return this.authenticationUsername;
    }

    @JsonProperty(value="broker_url")
    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public String getServiceBrokerId() {
        return this.serviceBrokerId;
    }

    public static class UpdateServiceBrokerRequestBuilder {
        private String authenticationPassword;
        private String authenticationUsername;
        private String brokerUrl;
        private String name;
        private String serviceBrokerId;

        UpdateServiceBrokerRequestBuilder() {
        }

        public UpdateServiceBrokerRequestBuilder authenticationPassword(String authenticationPassword) {
            this.authenticationPassword = authenticationPassword;
            return this;
        }

        public UpdateServiceBrokerRequestBuilder authenticationUsername(String authenticationUsername) {
            this.authenticationUsername = authenticationUsername;
            return this;
        }

        public UpdateServiceBrokerRequestBuilder brokerUrl(String brokerUrl) {
            this.brokerUrl = brokerUrl;
            return this;
        }

        public UpdateServiceBrokerRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UpdateServiceBrokerRequestBuilder serviceBrokerId(String serviceBrokerId) {
            this.serviceBrokerId = serviceBrokerId;
            return this;
        }

        public UpdateServiceBrokerRequest build() {
            return new UpdateServiceBrokerRequest(this.authenticationPassword, this.authenticationUsername, this.brokerUrl, this.name, this.serviceBrokerId);
        }

        public String toString() {
            return "UpdateServiceBrokerRequest.UpdateServiceBrokerRequestBuilder(authenticationPassword=" + this.authenticationPassword + ", authenticationUsername=" + this.authenticationUsername + ", brokerUrl=" + this.brokerUrl + ", name=" + this.name + ", serviceBrokerId=" + this.serviceBrokerId + ")";
        }
    }
}

