/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class BindServiceInstanceToRouteRequest
implements Validatable {
    private final Map<String, Object> parameters;
    private final String routeId;
    private final String serviceInstanceId;

    BindServiceInstanceToRouteRequest(Map<String, Object> parameters, String routeId, String serviceInstanceId) {
        this.parameters = parameters;
        this.routeId = routeId;
        this.serviceInstanceId = serviceInstanceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceInstanceId == null) {
            builder.message("service instance id must be specified");
        }
        if (this.routeId == null) {
            builder.message("route id must be specified");
        }
        return builder.build();
    }

    public static BindServiceInstanceToRouteRequestBuilder builder() {
        return new BindServiceInstanceToRouteRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BindServiceInstanceToRouteRequest)) {
            return false;
        }
        BindServiceInstanceToRouteRequest other = (BindServiceInstanceToRouteRequest)o;
        Map<String, Object> this$parameters = this.getParameters();
        Map<String, Object> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$routeId = this.getRouteId();
        String other$routeId = other.getRouteId();
        if (this$routeId == null ? other$routeId != null : !this$routeId.equals(other$routeId)) {
            return false;
        }
        String this$serviceInstanceId = this.getServiceInstanceId();
        String other$serviceInstanceId = other.getServiceInstanceId();
        return !(this$serviceInstanceId == null ? other$serviceInstanceId != null : !this$serviceInstanceId.equals(other$serviceInstanceId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $routeId = this.getRouteId();
        result = result * 59 + ($routeId == null ? 43 : $routeId.hashCode());
        String $serviceInstanceId = this.getServiceInstanceId();
        result = result * 59 + ($serviceInstanceId == null ? 43 : $serviceInstanceId.hashCode());
        return result;
    }

    public String toString() {
        return "BindServiceInstanceToRouteRequest(parameters=" + this.getParameters() + ", routeId=" + this.getRouteId() + ", serviceInstanceId=" + this.getServiceInstanceId() + ")";
    }

    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @JsonIgnore
    public String getRouteId() {
        return this.routeId;
    }

    @JsonIgnore
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public static class BindServiceInstanceToRouteRequestBuilder {
        private ArrayList<String> parameters$key;
        private ArrayList<Object> parameters$value;
        private String routeId;
        private String serviceInstanceId;

        BindServiceInstanceToRouteRequestBuilder() {
        }

        public BindServiceInstanceToRouteRequestBuilder parameter(String parameterKey, Object parameterValue) {
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            this.parameters$key.add(parameterKey);
            this.parameters$value.add(parameterValue);
            return this;
        }

        public BindServiceInstanceToRouteRequestBuilder parameters(Map<? extends String, ? extends Object> parameters) {
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : parameters.entrySet()) {
                this.parameters$key.add($lombokEntry.getKey());
                this.parameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public BindServiceInstanceToRouteRequestBuilder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public BindServiceInstanceToRouteRequestBuilder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public BindServiceInstanceToRouteRequest build() {
            Map<String, Object> parameters;
            switch (this.parameters$key == null ? 0 : this.parameters$key.size()) {
                case 0: {
                    parameters = Collections.emptyMap();
                    break;
                }
                case 1: {
                    parameters = Collections.singletonMap(this.parameters$key.get(0), this.parameters$value.get(0));
                    break;
                }
                default: {
                    parameters = new LinkedHashMap(this.parameters$key.size() < 0x40000000 ? 1 + this.parameters$key.size() + (this.parameters$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.parameters$key.size(); ++$i) {
                        parameters.put(this.parameters$key.get($i), this.parameters$value.get($i));
                    }
                    parameters = Collections.unmodifiableMap(parameters);
                }
            }
            return new BindServiceInstanceToRouteRequest(parameters, this.routeId, this.serviceInstanceId);
        }

        public String toString() {
            return "BindServiceInstanceToRouteRequest.BindServiceInstanceToRouteRequestBuilder(parameters$key=" + this.parameters$key + ", parameters$value=" + this.parameters$value + ", routeId=" + this.routeId + ", serviceInstanceId=" + this.serviceInstanceId + ")";
        }
    }
}

