/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CreateServiceInstanceRequest
implements Validatable {
    private final boolean acceptsIncomplete;
    private final String name;
    private final Map<String, Object> parameters;
    private final String servicePlanId;
    private final String spaceId;
    private final List<String> tags;

    CreateServiceInstanceRequest(boolean acceptsIncomplete, String name, Map<String, Object> parameters, String servicePlanId, String spaceId, List<String> tags) {
        this.acceptsIncomplete = acceptsIncomplete;
        this.name = name;
        this.parameters = parameters;
        this.servicePlanId = servicePlanId;
        this.spaceId = spaceId;
        this.tags = tags;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if (this.servicePlanId == null) {
            builder.message("service plan id must be specified");
        }
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static CreateServiceInstanceRequestBuilder builder() {
        return new CreateServiceInstanceRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateServiceInstanceRequest)) {
            return false;
        }
        CreateServiceInstanceRequest other = (CreateServiceInstanceRequest)o;
        if (this.isAcceptsIncomplete() != other.isAcceptsIncomplete()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, Object> this$parameters = this.getParameters();
        Map<String, Object> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$servicePlanId = this.getServicePlanId();
        String other$servicePlanId = other.getServicePlanId();
        if (this$servicePlanId == null ? other$servicePlanId != null : !this$servicePlanId.equals(other$servicePlanId)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAcceptsIncomplete() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, Object> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $servicePlanId = this.getServicePlanId();
        result = result * 59 + ($servicePlanId == null ? 43 : $servicePlanId.hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "CreateServiceInstanceRequest(acceptsIncomplete=" + this.isAcceptsIncomplete() + ", name=" + this.getName() + ", parameters=" + this.getParameters() + ", servicePlanId=" + this.getServicePlanId() + ", spaceId=" + this.getSpaceId() + ", tags=" + this.getTags() + ")";
    }

    @QueryParameter(value="accepts_incomplete")
    public boolean isAcceptsIncomplete() {
        return this.acceptsIncomplete;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="service_plan_guid")
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    @JsonProperty(value="space_guid")
    public String getSpaceId() {
        return this.spaceId;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getTags() {
        return this.tags;
    }

    public static class CreateServiceInstanceRequestBuilder {
        private boolean acceptsIncomplete;
        private String name;
        private ArrayList<String> parameters$key;
        private ArrayList<Object> parameters$value;
        private String servicePlanId;
        private String spaceId;
        private ArrayList<String> tags;

        CreateServiceInstanceRequestBuilder() {
        }

        public CreateServiceInstanceRequestBuilder acceptsIncomplete(boolean acceptsIncomplete) {
            this.acceptsIncomplete = acceptsIncomplete;
            return this;
        }

        public CreateServiceInstanceRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateServiceInstanceRequestBuilder parameter(String parameterKey, Object parameterValue) {
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            this.parameters$key.add(parameterKey);
            this.parameters$value.add(parameterValue);
            return this;
        }

        public CreateServiceInstanceRequestBuilder parameters(Map<? extends String, ? extends Object> parameters) {
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : parameters.entrySet()) {
                this.parameters$key.add($lombokEntry.getKey());
                this.parameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CreateServiceInstanceRequestBuilder servicePlanId(String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        public CreateServiceInstanceRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public CreateServiceInstanceRequestBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public CreateServiceInstanceRequestBuilder tags(Collection<? extends String> tags) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public CreateServiceInstanceRequest build() {
            List<String> tags;
            Map<String, Object> parameters;
            switch (this.parameters$key == null ? 0 : this.parameters$key.size()) {
                case 0: {
                    parameters = Collections.emptyMap();
                    break;
                }
                case 1: {
                    parameters = Collections.singletonMap(this.parameters$key.get(0), this.parameters$value.get(0));
                    break;
                }
                default: {
                    parameters = new LinkedHashMap(this.parameters$key.size() < 0x40000000 ? 1 + this.parameters$key.size() + (this.parameters$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.parameters$key.size(); ++$i) {
                        parameters.put(this.parameters$key.get($i), this.parameters$value.get($i));
                    }
                    parameters = Collections.unmodifiableMap(parameters);
                }
            }
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<String>(this.tags));
                }
            }
            return new CreateServiceInstanceRequest(this.acceptsIncomplete, this.name, parameters, this.servicePlanId, this.spaceId, tags);
        }

        public String toString() {
            return "CreateServiceInstanceRequest.CreateServiceInstanceRequestBuilder(acceptsIncomplete=" + this.acceptsIncomplete + ", name=" + this.name + ", parameters$key=" + this.parameters$key + ", parameters$value=" + this.parameters$value + ", servicePlanId=" + this.servicePlanId + ", spaceId=" + this.spaceId + ", tags=" + this.tags + ")";
        }
    }
}

