/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class DeleteServiceInstanceRequest
implements Validatable {
    private final Boolean acceptsIncomplete;
    private final Boolean async;
    private final Boolean purge;
    private final Boolean recursive;
    private final String serviceInstanceId;

    DeleteServiceInstanceRequest(Boolean acceptsIncomplete, Boolean async, Boolean purge, Boolean recursive, String serviceInstanceId) {
        this.acceptsIncomplete = acceptsIncomplete;
        this.async = async;
        this.purge = purge;
        this.recursive = recursive;
        this.serviceInstanceId = serviceInstanceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceInstanceId == null) {
            builder.message("service instance id must be specified");
        }
        return builder.build();
    }

    public static DeleteServiceInstanceRequestBuilder builder() {
        return new DeleteServiceInstanceRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteServiceInstanceRequest)) {
            return false;
        }
        DeleteServiceInstanceRequest other = (DeleteServiceInstanceRequest)o;
        Boolean this$acceptsIncomplete = this.getAcceptsIncomplete();
        Boolean other$acceptsIncomplete = other.getAcceptsIncomplete();
        if (this$acceptsIncomplete == null ? other$acceptsIncomplete != null : !((Object)this$acceptsIncomplete).equals(other$acceptsIncomplete)) {
            return false;
        }
        Boolean this$async = this.getAsync();
        Boolean other$async = other.getAsync();
        if (this$async == null ? other$async != null : !((Object)this$async).equals(other$async)) {
            return false;
        }
        Boolean this$purge = this.getPurge();
        Boolean other$purge = other.getPurge();
        if (this$purge == null ? other$purge != null : !((Object)this$purge).equals(other$purge)) {
            return false;
        }
        Boolean this$recursive = this.getRecursive();
        Boolean other$recursive = other.getRecursive();
        if (this$recursive == null ? other$recursive != null : !((Object)this$recursive).equals(other$recursive)) {
            return false;
        }
        String this$serviceInstanceId = this.getServiceInstanceId();
        String other$serviceInstanceId = other.getServiceInstanceId();
        return !(this$serviceInstanceId == null ? other$serviceInstanceId != null : !this$serviceInstanceId.equals(other$serviceInstanceId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $acceptsIncomplete = this.getAcceptsIncomplete();
        result = result * 59 + ($acceptsIncomplete == null ? 43 : ((Object)$acceptsIncomplete).hashCode());
        Boolean $async = this.getAsync();
        result = result * 59 + ($async == null ? 43 : ((Object)$async).hashCode());
        Boolean $purge = this.getPurge();
        result = result * 59 + ($purge == null ? 43 : ((Object)$purge).hashCode());
        Boolean $recursive = this.getRecursive();
        result = result * 59 + ($recursive == null ? 43 : ((Object)$recursive).hashCode());
        String $serviceInstanceId = this.getServiceInstanceId();
        result = result * 59 + ($serviceInstanceId == null ? 43 : $serviceInstanceId.hashCode());
        return result;
    }

    public String toString() {
        return "DeleteServiceInstanceRequest(acceptsIncomplete=" + this.getAcceptsIncomplete() + ", async=" + this.getAsync() + ", purge=" + this.getPurge() + ", recursive=" + this.getRecursive() + ", serviceInstanceId=" + this.getServiceInstanceId() + ")";
    }

    @QueryParameter(value="accepts_incomplete")
    public Boolean getAcceptsIncomplete() {
        return this.acceptsIncomplete;
    }

    @QueryParameter(value="async")
    public Boolean getAsync() {
        return this.async;
    }

    @QueryParameter(value="purge")
    public Boolean getPurge() {
        return this.purge;
    }

    @QueryParameter(value="recursive")
    public Boolean getRecursive() {
        return this.recursive;
    }

    @JsonIgnore
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public static class DeleteServiceInstanceRequestBuilder {
        private Boolean acceptsIncomplete;
        private Boolean async;
        private Boolean purge;
        private Boolean recursive;
        private String serviceInstanceId;

        DeleteServiceInstanceRequestBuilder() {
        }

        public DeleteServiceInstanceRequestBuilder acceptsIncomplete(Boolean acceptsIncomplete) {
            this.acceptsIncomplete = acceptsIncomplete;
            return this;
        }

        public DeleteServiceInstanceRequestBuilder async(Boolean async) {
            this.async = async;
            return this;
        }

        public DeleteServiceInstanceRequestBuilder purge(Boolean purge) {
            this.purge = purge;
            return this;
        }

        public DeleteServiceInstanceRequestBuilder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public DeleteServiceInstanceRequestBuilder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public DeleteServiceInstanceRequest build() {
            return new DeleteServiceInstanceRequest(this.acceptsIncomplete, this.async, this.purge, this.recursive, this.serviceInstanceId);
        }

        public String toString() {
            return "DeleteServiceInstanceRequest.DeleteServiceInstanceRequestBuilder(acceptsIncomplete=" + this.acceptsIncomplete + ", async=" + this.async + ", purge=" + this.purge + ", recursive=" + this.recursive + ", serviceInstanceId=" + this.serviceInstanceId + ")";
        }
    }
}

