/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class GetServiceInstancePermissionsRequest
implements Validatable {
    private final String serviceInstanceId;

    GetServiceInstancePermissionsRequest(String serviceInstanceId) {
        this.serviceInstanceId = serviceInstanceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceInstanceId == null) {
            builder.message("service instance id must be specified");
        }
        return builder.build();
    }

    public static GetServiceInstancePermissionsRequestBuilder builder() {
        return new GetServiceInstancePermissionsRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetServiceInstancePermissionsRequest)) {
            return false;
        }
        GetServiceInstancePermissionsRequest other = (GetServiceInstancePermissionsRequest)o;
        String this$serviceInstanceId = this.getServiceInstanceId();
        String other$serviceInstanceId = other.getServiceInstanceId();
        return !(this$serviceInstanceId == null ? other$serviceInstanceId != null : !this$serviceInstanceId.equals(other$serviceInstanceId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceInstanceId = this.getServiceInstanceId();
        result = result * 59 + ($serviceInstanceId == null ? 43 : $serviceInstanceId.hashCode());
        return result;
    }

    public String toString() {
        return "GetServiceInstancePermissionsRequest(serviceInstanceId=" + this.getServiceInstanceId() + ")";
    }

    @JsonIgnore
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public static class GetServiceInstancePermissionsRequestBuilder {
        private String serviceInstanceId;

        GetServiceInstancePermissionsRequestBuilder() {
        }

        public GetServiceInstancePermissionsRequestBuilder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public GetServiceInstancePermissionsRequest build() {
            return new GetServiceInstancePermissionsRequest(this.serviceInstanceId);
        }

        public String toString() {
            return "GetServiceInstancePermissionsRequest.GetServiceInstancePermissionsRequestBuilder(serviceInstanceId=" + this.serviceInstanceId + ")";
        }
    }
}

