/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class GetServiceInstanceRequest
implements Validatable {
    private final String serviceInstanceId;

    GetServiceInstanceRequest(String serviceInstanceId) {
        this.serviceInstanceId = serviceInstanceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceInstanceId == null) {
            builder.message("service instance id must be specified");
        }
        return builder.build();
    }

    public static GetServiceInstanceRequestBuilder builder() {
        return new GetServiceInstanceRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetServiceInstanceRequest)) {
            return false;
        }
        GetServiceInstanceRequest other = (GetServiceInstanceRequest)o;
        String this$serviceInstanceId = this.getServiceInstanceId();
        String other$serviceInstanceId = other.getServiceInstanceId();
        return !(this$serviceInstanceId == null ? other$serviceInstanceId != null : !this$serviceInstanceId.equals(other$serviceInstanceId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceInstanceId = this.getServiceInstanceId();
        result = result * 59 + ($serviceInstanceId == null ? 43 : $serviceInstanceId.hashCode());
        return result;
    }

    public String toString() {
        return "GetServiceInstanceRequest(serviceInstanceId=" + this.getServiceInstanceId() + ")";
    }

    @JsonIgnore
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public static class GetServiceInstanceRequestBuilder {
        private String serviceInstanceId;

        GetServiceInstanceRequestBuilder() {
        }

        public GetServiceInstanceRequestBuilder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public GetServiceInstanceRequest build() {
            return new GetServiceInstanceRequest(this.serviceInstanceId);
        }

        public String toString() {
            return "GetServiceInstanceRequest.GetServiceInstanceRequestBuilder(serviceInstanceId=" + this.serviceInstanceId + ")";
        }
    }
}

