/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListServiceInstanceServiceBindingsRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> applicationIds;
    private final String serviceInstanceId;

    ListServiceInstanceServiceBindingsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> applicationIds, String serviceInstanceId) {
        super(orderDirection, page, resultsPerPage);
        this.applicationIds = applicationIds;
        this.serviceInstanceId = serviceInstanceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceInstanceId == null) {
            builder.message("service instance id must be specified");
        }
        return builder.build();
    }

    public static ListServiceInstanceServiceBindingsRequestBuilder builder() {
        return new ListServiceInstanceServiceBindingsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListServiceInstanceServiceBindingsRequest)) {
            return false;
        }
        ListServiceInstanceServiceBindingsRequest other = (ListServiceInstanceServiceBindingsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$applicationIds = this.getApplicationIds();
        List<String> other$applicationIds = other.getApplicationIds();
        if (this$applicationIds == null ? other$applicationIds != null : !((Object)this$applicationIds).equals(other$applicationIds)) {
            return false;
        }
        String this$serviceInstanceId = this.getServiceInstanceId();
        String other$serviceInstanceId = other.getServiceInstanceId();
        return !(this$serviceInstanceId == null ? other$serviceInstanceId != null : !this$serviceInstanceId.equals(other$serviceInstanceId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListServiceInstanceServiceBindingsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $applicationIds = this.getApplicationIds();
        result = result * 59 + ($applicationIds == null ? 43 : ((Object)$applicationIds).hashCode());
        String $serviceInstanceId = this.getServiceInstanceId();
        result = result * 59 + ($serviceInstanceId == null ? 43 : $serviceInstanceId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListServiceInstanceServiceBindingsRequest(super=" + super.toString() + ", applicationIds=" + this.getApplicationIds() + ", serviceInstanceId=" + this.getServiceInstanceId() + ")";
    }

    @InFilterParameter(value="app_guid")
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @JsonIgnore
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public static class ListServiceInstanceServiceBindingsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> applicationIds;
        private String serviceInstanceId;

        ListServiceInstanceServiceBindingsRequestBuilder() {
        }

        public ListServiceInstanceServiceBindingsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListServiceInstanceServiceBindingsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListServiceInstanceServiceBindingsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListServiceInstanceServiceBindingsRequestBuilder applicationId(String applicationId) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList();
            }
            this.applicationIds.add(applicationId);
            return this;
        }

        public ListServiceInstanceServiceBindingsRequestBuilder applicationIds(Collection<? extends String> applicationIds) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList();
            }
            this.applicationIds.addAll(applicationIds);
            return this;
        }

        public ListServiceInstanceServiceBindingsRequestBuilder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public ListServiceInstanceServiceBindingsRequest build() {
            List<String> applicationIds;
            switch (this.applicationIds == null ? 0 : this.applicationIds.size()) {
                case 0: {
                    applicationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    applicationIds = Collections.singletonList(this.applicationIds.get(0));
                    break;
                }
                default: {
                    applicationIds = Collections.unmodifiableList(new ArrayList<String>(this.applicationIds));
                }
            }
            return new ListServiceInstanceServiceBindingsRequest(this.orderDirection, this.page, this.resultsPerPage, applicationIds, this.serviceInstanceId);
        }

        public String toString() {
            return "ListServiceInstanceServiceBindingsRequest.ListServiceInstanceServiceBindingsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", applicationIds=" + this.applicationIds + ", serviceInstanceId=" + this.serviceInstanceId + ")";
        }
    }
}

