/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.servicebindings.ServiceBindingResource;

public final class ListServiceInstanceServiceBindingsResponse
extends PaginatedResponse<ServiceBindingResource> {
    ListServiceInstanceServiceBindingsResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<ServiceBindingResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListServiceInstanceServiceBindingsResponseBuilder builder() {
        return new ListServiceInstanceServiceBindingsResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListServiceInstanceServiceBindingsResponse)) {
            return false;
        }
        ListServiceInstanceServiceBindingsResponse other = (ListServiceInstanceServiceBindingsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListServiceInstanceServiceBindingsResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListServiceInstanceServiceBindingsResponse(super=" + super.toString() + ")";
    }

    public static class ListServiceInstanceServiceBindingsResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<ServiceBindingResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListServiceInstanceServiceBindingsResponseBuilder() {
        }

        public ListServiceInstanceServiceBindingsResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListServiceInstanceServiceBindingsResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListServiceInstanceServiceBindingsResponseBuilder resource(ServiceBindingResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListServiceInstanceServiceBindingsResponseBuilder resources(Collection<? extends ServiceBindingResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListServiceInstanceServiceBindingsResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListServiceInstanceServiceBindingsResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListServiceInstanceServiceBindingsResponse build() {
            List<ServiceBindingResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<ServiceBindingResource>(this.resources));
                }
            }
            return new ListServiceInstanceServiceBindingsResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListServiceInstanceServiceBindingsResponse.ListServiceInstanceServiceBindingsResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

