/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListServiceInstancesRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> gatewayNames;
    private final List<String> names;
    private final List<String> organizationIds;
    private final List<String> serviceBindingIds;
    private final List<String> serviceKeyIds;
    private final List<String> servicePlanIds;
    private final List<String> spaceIds;

    ListServiceInstancesRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> gatewayNames, List<String> names, List<String> organizationIds, List<String> serviceBindingIds, List<String> serviceKeyIds, List<String> servicePlanIds, List<String> spaceIds) {
        super(orderDirection, page, resultsPerPage);
        this.gatewayNames = gatewayNames;
        this.names = names;
        this.organizationIds = organizationIds;
        this.serviceKeyIds = serviceKeyIds;
        this.serviceBindingIds = serviceBindingIds;
        this.servicePlanIds = servicePlanIds;
        this.spaceIds = spaceIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    public static ListServiceInstancesRequestBuilder builder() {
        return new ListServiceInstancesRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListServiceInstancesRequest)) {
            return false;
        }
        ListServiceInstancesRequest other = (ListServiceInstancesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$gatewayNames = this.getGatewayNames();
        List<String> other$gatewayNames = other.getGatewayNames();
        if (this$gatewayNames == null ? other$gatewayNames != null : !((Object)this$gatewayNames).equals(other$gatewayNames)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        List<String> this$organizationIds = this.getOrganizationIds();
        List<String> other$organizationIds = other.getOrganizationIds();
        if (this$organizationIds == null ? other$organizationIds != null : !((Object)this$organizationIds).equals(other$organizationIds)) {
            return false;
        }
        List<String> this$serviceBindingIds = this.getServiceBindingIds();
        List<String> other$serviceBindingIds = other.getServiceBindingIds();
        if (this$serviceBindingIds == null ? other$serviceBindingIds != null : !((Object)this$serviceBindingIds).equals(other$serviceBindingIds)) {
            return false;
        }
        List<String> this$serviceKeyIds = this.getServiceKeyIds();
        List<String> other$serviceKeyIds = other.getServiceKeyIds();
        if (this$serviceKeyIds == null ? other$serviceKeyIds != null : !((Object)this$serviceKeyIds).equals(other$serviceKeyIds)) {
            return false;
        }
        List<String> this$servicePlanIds = this.getServicePlanIds();
        List<String> other$servicePlanIds = other.getServicePlanIds();
        if (this$servicePlanIds == null ? other$servicePlanIds != null : !((Object)this$servicePlanIds).equals(other$servicePlanIds)) {
            return false;
        }
        List<String> this$spaceIds = this.getSpaceIds();
        List<String> other$spaceIds = other.getSpaceIds();
        return !(this$spaceIds == null ? other$spaceIds != null : !((Object)this$spaceIds).equals(other$spaceIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListServiceInstancesRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $gatewayNames = this.getGatewayNames();
        result = result * 59 + ($gatewayNames == null ? 43 : ((Object)$gatewayNames).hashCode());
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        List<String> $organizationIds = this.getOrganizationIds();
        result = result * 59 + ($organizationIds == null ? 43 : ((Object)$organizationIds).hashCode());
        List<String> $serviceBindingIds = this.getServiceBindingIds();
        result = result * 59 + ($serviceBindingIds == null ? 43 : ((Object)$serviceBindingIds).hashCode());
        List<String> $serviceKeyIds = this.getServiceKeyIds();
        result = result * 59 + ($serviceKeyIds == null ? 43 : ((Object)$serviceKeyIds).hashCode());
        List<String> $servicePlanIds = this.getServicePlanIds();
        result = result * 59 + ($servicePlanIds == null ? 43 : ((Object)$servicePlanIds).hashCode());
        List<String> $spaceIds = this.getSpaceIds();
        result = result * 59 + ($spaceIds == null ? 43 : ((Object)$spaceIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListServiceInstancesRequest(super=" + super.toString() + ", gatewayNames=" + this.getGatewayNames() + ", names=" + this.getNames() + ", organizationIds=" + this.getOrganizationIds() + ", serviceBindingIds=" + this.getServiceBindingIds() + ", serviceKeyIds=" + this.getServiceKeyIds() + ", servicePlanIds=" + this.getServicePlanIds() + ", spaceIds=" + this.getSpaceIds() + ")";
    }

    @InFilterParameter(value="gateway_name")
    public List<String> getGatewayNames() {
        return this.gatewayNames;
    }

    @InFilterParameter(value="name")
    public List<String> getNames() {
        return this.names;
    }

    @InFilterParameter(value="organization_guid")
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @InFilterParameter(value="service_binding_guid")
    public List<String> getServiceBindingIds() {
        return this.serviceBindingIds;
    }

    @InFilterParameter(value="service_key_guid")
    public List<String> getServiceKeyIds() {
        return this.serviceKeyIds;
    }

    @InFilterParameter(value="service_plan_guid")
    public List<String> getServicePlanIds() {
        return this.servicePlanIds;
    }

    @InFilterParameter(value="space_guid")
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    public static class ListServiceInstancesRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> gatewayNames;
        private ArrayList<String> names;
        private ArrayList<String> organizationIds;
        private ArrayList<String> serviceBindingIds;
        private ArrayList<String> serviceKeyIds;
        private ArrayList<String> servicePlanIds;
        private ArrayList<String> spaceIds;

        ListServiceInstancesRequestBuilder() {
        }

        public ListServiceInstancesRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListServiceInstancesRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListServiceInstancesRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListServiceInstancesRequestBuilder gatewayName(String gatewayName) {
            if (this.gatewayNames == null) {
                this.gatewayNames = new ArrayList();
            }
            this.gatewayNames.add(gatewayName);
            return this;
        }

        public ListServiceInstancesRequestBuilder gatewayNames(Collection<? extends String> gatewayNames) {
            if (this.gatewayNames == null) {
                this.gatewayNames = new ArrayList();
            }
            this.gatewayNames.addAll(gatewayNames);
            return this;
        }

        public ListServiceInstancesRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListServiceInstancesRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListServiceInstancesRequestBuilder organizationId(String organizationId) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.add(organizationId);
            return this;
        }

        public ListServiceInstancesRequestBuilder organizationIds(Collection<? extends String> organizationIds) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.addAll(organizationIds);
            return this;
        }

        public ListServiceInstancesRequestBuilder serviceBindingId(String serviceBindingId) {
            if (this.serviceBindingIds == null) {
                this.serviceBindingIds = new ArrayList();
            }
            this.serviceBindingIds.add(serviceBindingId);
            return this;
        }

        public ListServiceInstancesRequestBuilder serviceBindingIds(Collection<? extends String> serviceBindingIds) {
            if (this.serviceBindingIds == null) {
                this.serviceBindingIds = new ArrayList();
            }
            this.serviceBindingIds.addAll(serviceBindingIds);
            return this;
        }

        public ListServiceInstancesRequestBuilder serviceKeyId(String serviceKeyId) {
            if (this.serviceKeyIds == null) {
                this.serviceKeyIds = new ArrayList();
            }
            this.serviceKeyIds.add(serviceKeyId);
            return this;
        }

        public ListServiceInstancesRequestBuilder serviceKeyIds(Collection<? extends String> serviceKeyIds) {
            if (this.serviceKeyIds == null) {
                this.serviceKeyIds = new ArrayList();
            }
            this.serviceKeyIds.addAll(serviceKeyIds);
            return this;
        }

        public ListServiceInstancesRequestBuilder servicePlanId(String servicePlanId) {
            if (this.servicePlanIds == null) {
                this.servicePlanIds = new ArrayList();
            }
            this.servicePlanIds.add(servicePlanId);
            return this;
        }

        public ListServiceInstancesRequestBuilder servicePlanIds(Collection<? extends String> servicePlanIds) {
            if (this.servicePlanIds == null) {
                this.servicePlanIds = new ArrayList();
            }
            this.servicePlanIds.addAll(servicePlanIds);
            return this;
        }

        public ListServiceInstancesRequestBuilder spaceId(String spaceId) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList();
            }
            this.spaceIds.add(spaceId);
            return this;
        }

        public ListServiceInstancesRequestBuilder spaceIds(Collection<? extends String> spaceIds) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList();
            }
            this.spaceIds.addAll(spaceIds);
            return this;
        }

        public ListServiceInstancesRequest build() {
            List<String> spaceIds;
            List<String> servicePlanIds;
            List<String> serviceKeyIds;
            List<String> serviceBindingIds;
            List<String> organizationIds;
            List<String> names;
            List<String> gatewayNames;
            switch (this.gatewayNames == null ? 0 : this.gatewayNames.size()) {
                case 0: {
                    gatewayNames = Collections.emptyList();
                    break;
                }
                case 1: {
                    gatewayNames = Collections.singletonList(this.gatewayNames.get(0));
                    break;
                }
                default: {
                    gatewayNames = Collections.unmodifiableList(new ArrayList<String>(this.gatewayNames));
                }
            }
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            switch (this.organizationIds == null ? 0 : this.organizationIds.size()) {
                case 0: {
                    organizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    organizationIds = Collections.singletonList(this.organizationIds.get(0));
                    break;
                }
                default: {
                    organizationIds = Collections.unmodifiableList(new ArrayList<String>(this.organizationIds));
                }
            }
            switch (this.serviceBindingIds == null ? 0 : this.serviceBindingIds.size()) {
                case 0: {
                    serviceBindingIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceBindingIds = Collections.singletonList(this.serviceBindingIds.get(0));
                    break;
                }
                default: {
                    serviceBindingIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceBindingIds));
                }
            }
            switch (this.serviceKeyIds == null ? 0 : this.serviceKeyIds.size()) {
                case 0: {
                    serviceKeyIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceKeyIds = Collections.singletonList(this.serviceKeyIds.get(0));
                    break;
                }
                default: {
                    serviceKeyIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceKeyIds));
                }
            }
            switch (this.servicePlanIds == null ? 0 : this.servicePlanIds.size()) {
                case 0: {
                    servicePlanIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    servicePlanIds = Collections.singletonList(this.servicePlanIds.get(0));
                    break;
                }
                default: {
                    servicePlanIds = Collections.unmodifiableList(new ArrayList<String>(this.servicePlanIds));
                }
            }
            switch (this.spaceIds == null ? 0 : this.spaceIds.size()) {
                case 0: {
                    spaceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    spaceIds = Collections.singletonList(this.spaceIds.get(0));
                    break;
                }
                default: {
                    spaceIds = Collections.unmodifiableList(new ArrayList<String>(this.spaceIds));
                }
            }
            return new ListServiceInstancesRequest(this.orderDirection, this.page, this.resultsPerPage, gatewayNames, names, organizationIds, serviceBindingIds, serviceKeyIds, servicePlanIds, spaceIds);
        }

        public String toString() {
            return "ListServiceInstancesRequest.ListServiceInstancesRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", gatewayNames=" + this.gatewayNames + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ", serviceBindingIds=" + this.serviceBindingIds + ", serviceKeyIds=" + this.serviceKeyIds + ", servicePlanIds=" + this.servicePlanIds + ", spaceIds=" + this.spaceIds + ")";
        }
    }
}

