/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.cloudfoundry.client.v2.serviceinstances.BaseServiceInstanceEntity;
import org.cloudfoundry.client.v2.serviceinstances.LastOperation;

public final class UnionServiceInstanceEntity
extends BaseServiceInstanceEntity {
    private final String dashboardUrl;
    private final String gatewayData;
    private final LastOperation lastOperation;
    private final String routeServiceUrl;
    private final String serviceKeysUrl;
    private final String servicePlanId;
    private final String servicePlanUrl;
    private final String syslogDrainUrl;
    private final List<String> tags;

    UnionServiceInstanceEntity(@JsonProperty(value="credentials") Map<String, Object> credentials, @JsonProperty(value="dashboard_url") String dashboardUrl, @JsonProperty(value="gateway_data") @Deprecated String gatewayData, @JsonProperty(value="last_operation") LastOperation lastOperation, @JsonProperty(value="name") String name, @JsonProperty(value="route_service_url") String routeServiceUrl, @JsonProperty(value="routes_url") String routesUrl, @JsonProperty(value="service_bindings_url") String serviceBindingsUrl, @JsonProperty(value="service_keys_url") String serviceKeysUrl, @JsonProperty(value="service_plan_guid") String servicePlanId, @JsonProperty(value="service_plan_url") String servicePlanUrl, @JsonProperty(value="space_guid") String spaceId, @JsonProperty(value="space_url") String spaceUrl, @JsonProperty(value="syslog_drain_url") String syslogDrainUrl, @JsonProperty(value="tags") List<String> tags, @JsonProperty(value="type") String type) {
        super(credentials, name, routesUrl, serviceBindingsUrl, spaceId, spaceUrl, type);
        this.dashboardUrl = dashboardUrl;
        this.gatewayData = gatewayData;
        this.lastOperation = lastOperation;
        this.routeServiceUrl = routeServiceUrl;
        this.serviceKeysUrl = serviceKeysUrl;
        this.servicePlanId = servicePlanId;
        this.servicePlanUrl = servicePlanUrl;
        this.syslogDrainUrl = syslogDrainUrl;
        this.tags = Optional.ofNullable(tags).orElse(Collections.emptyList());
    }

    public static UnionServiceInstanceEntityBuilder builder() {
        return new UnionServiceInstanceEntityBuilder();
    }

    public String getDashboardUrl() {
        return this.dashboardUrl;
    }

    public LastOperation getLastOperation() {
        return this.lastOperation;
    }

    public String getRouteServiceUrl() {
        return this.routeServiceUrl;
    }

    public String getServiceKeysUrl() {
        return this.serviceKeysUrl;
    }

    public String getServicePlanId() {
        return this.servicePlanId;
    }

    public String getServicePlanUrl() {
        return this.servicePlanUrl;
    }

    public String getSyslogDrainUrl() {
        return this.syslogDrainUrl;
    }

    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnionServiceInstanceEntity)) {
            return false;
        }
        UnionServiceInstanceEntity other = (UnionServiceInstanceEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$dashboardUrl = this.getDashboardUrl();
        String other$dashboardUrl = other.getDashboardUrl();
        if (this$dashboardUrl == null ? other$dashboardUrl != null : !this$dashboardUrl.equals(other$dashboardUrl)) {
            return false;
        }
        String this$gatewayData = this.getGatewayData();
        String other$gatewayData = other.getGatewayData();
        if (this$gatewayData == null ? other$gatewayData != null : !this$gatewayData.equals(other$gatewayData)) {
            return false;
        }
        LastOperation this$lastOperation = this.getLastOperation();
        LastOperation other$lastOperation = other.getLastOperation();
        if (this$lastOperation == null ? other$lastOperation != null : !((Object)this$lastOperation).equals(other$lastOperation)) {
            return false;
        }
        String this$routeServiceUrl = this.getRouteServiceUrl();
        String other$routeServiceUrl = other.getRouteServiceUrl();
        if (this$routeServiceUrl == null ? other$routeServiceUrl != null : !this$routeServiceUrl.equals(other$routeServiceUrl)) {
            return false;
        }
        String this$serviceKeysUrl = this.getServiceKeysUrl();
        String other$serviceKeysUrl = other.getServiceKeysUrl();
        if (this$serviceKeysUrl == null ? other$serviceKeysUrl != null : !this$serviceKeysUrl.equals(other$serviceKeysUrl)) {
            return false;
        }
        String this$servicePlanId = this.getServicePlanId();
        String other$servicePlanId = other.getServicePlanId();
        if (this$servicePlanId == null ? other$servicePlanId != null : !this$servicePlanId.equals(other$servicePlanId)) {
            return false;
        }
        String this$servicePlanUrl = this.getServicePlanUrl();
        String other$servicePlanUrl = other.getServicePlanUrl();
        if (this$servicePlanUrl == null ? other$servicePlanUrl != null : !this$servicePlanUrl.equals(other$servicePlanUrl)) {
            return false;
        }
        String this$syslogDrainUrl = this.getSyslogDrainUrl();
        String other$syslogDrainUrl = other.getSyslogDrainUrl();
        if (this$syslogDrainUrl == null ? other$syslogDrainUrl != null : !this$syslogDrainUrl.equals(other$syslogDrainUrl)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UnionServiceInstanceEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $dashboardUrl = this.getDashboardUrl();
        result = result * 59 + ($dashboardUrl == null ? 43 : $dashboardUrl.hashCode());
        String $gatewayData = this.getGatewayData();
        result = result * 59 + ($gatewayData == null ? 43 : $gatewayData.hashCode());
        LastOperation $lastOperation = this.getLastOperation();
        result = result * 59 + ($lastOperation == null ? 43 : ((Object)$lastOperation).hashCode());
        String $routeServiceUrl = this.getRouteServiceUrl();
        result = result * 59 + ($routeServiceUrl == null ? 43 : $routeServiceUrl.hashCode());
        String $serviceKeysUrl = this.getServiceKeysUrl();
        result = result * 59 + ($serviceKeysUrl == null ? 43 : $serviceKeysUrl.hashCode());
        String $servicePlanId = this.getServicePlanId();
        result = result * 59 + ($servicePlanId == null ? 43 : $servicePlanId.hashCode());
        String $servicePlanUrl = this.getServicePlanUrl();
        result = result * 59 + ($servicePlanUrl == null ? 43 : $servicePlanUrl.hashCode());
        String $syslogDrainUrl = this.getSyslogDrainUrl();
        result = result * 59 + ($syslogDrainUrl == null ? 43 : $syslogDrainUrl.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "UnionServiceInstanceEntity(super=" + super.toString() + ", dashboardUrl=" + this.getDashboardUrl() + ", gatewayData=" + this.getGatewayData() + ", lastOperation=" + this.getLastOperation() + ", routeServiceUrl=" + this.getRouteServiceUrl() + ", serviceKeysUrl=" + this.getServiceKeysUrl() + ", servicePlanId=" + this.getServicePlanId() + ", servicePlanUrl=" + this.getServicePlanUrl() + ", syslogDrainUrl=" + this.getSyslogDrainUrl() + ", tags=" + this.getTags() + ")";
    }

    @Deprecated
    public String getGatewayData() {
        return this.gatewayData;
    }

    public static class UnionServiceInstanceEntityBuilder {
        private ArrayList<String> credentials$key;
        private ArrayList<Object> credentials$value;
        private String dashboardUrl;
        private String gatewayData;
        private LastOperation lastOperation;
        private String name;
        private String routeServiceUrl;
        private String routesUrl;
        private String serviceBindingsUrl;
        private String serviceKeysUrl;
        private String servicePlanId;
        private String servicePlanUrl;
        private String spaceId;
        private String spaceUrl;
        private String syslogDrainUrl;
        private ArrayList<String> tags;
        private String type;

        UnionServiceInstanceEntityBuilder() {
        }

        public UnionServiceInstanceEntityBuilder credential(String credentialKey, Object credentialValue) {
            if (this.credentials$key == null) {
                this.credentials$key = new ArrayList();
                this.credentials$value = new ArrayList();
            }
            this.credentials$key.add(credentialKey);
            this.credentials$value.add(credentialValue);
            return this;
        }

        public UnionServiceInstanceEntityBuilder credentials(Map<? extends String, ? extends Object> credentials) {
            if (this.credentials$key == null) {
                this.credentials$key = new ArrayList();
                this.credentials$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : credentials.entrySet()) {
                this.credentials$key.add($lombokEntry.getKey());
                this.credentials$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public UnionServiceInstanceEntityBuilder dashboardUrl(String dashboardUrl) {
            this.dashboardUrl = dashboardUrl;
            return this;
        }

        public UnionServiceInstanceEntityBuilder gatewayData(String gatewayData) {
            this.gatewayData = gatewayData;
            return this;
        }

        public UnionServiceInstanceEntityBuilder lastOperation(LastOperation lastOperation) {
            this.lastOperation = lastOperation;
            return this;
        }

        public UnionServiceInstanceEntityBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UnionServiceInstanceEntityBuilder routeServiceUrl(String routeServiceUrl) {
            this.routeServiceUrl = routeServiceUrl;
            return this;
        }

        public UnionServiceInstanceEntityBuilder routesUrl(String routesUrl) {
            this.routesUrl = routesUrl;
            return this;
        }

        public UnionServiceInstanceEntityBuilder serviceBindingsUrl(String serviceBindingsUrl) {
            this.serviceBindingsUrl = serviceBindingsUrl;
            return this;
        }

        public UnionServiceInstanceEntityBuilder serviceKeysUrl(String serviceKeysUrl) {
            this.serviceKeysUrl = serviceKeysUrl;
            return this;
        }

        public UnionServiceInstanceEntityBuilder servicePlanId(String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        public UnionServiceInstanceEntityBuilder servicePlanUrl(String servicePlanUrl) {
            this.servicePlanUrl = servicePlanUrl;
            return this;
        }

        public UnionServiceInstanceEntityBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public UnionServiceInstanceEntityBuilder spaceUrl(String spaceUrl) {
            this.spaceUrl = spaceUrl;
            return this;
        }

        public UnionServiceInstanceEntityBuilder syslogDrainUrl(String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
            return this;
        }

        public UnionServiceInstanceEntityBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public UnionServiceInstanceEntityBuilder tags(Collection<? extends String> tags) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public UnionServiceInstanceEntityBuilder type(String type) {
            this.type = type;
            return this;
        }

        public UnionServiceInstanceEntity build() {
            List<String> tags;
            Map<Object, Object> credentials;
            switch (this.credentials$key == null ? 0 : this.credentials$key.size()) {
                case 0: {
                    credentials = Collections.emptyMap();
                    break;
                }
                case 1: {
                    credentials = Collections.singletonMap(this.credentials$key.get(0), this.credentials$value.get(0));
                    break;
                }
                default: {
                    credentials = new LinkedHashMap(this.credentials$key.size() < 0x40000000 ? 1 + this.credentials$key.size() + (this.credentials$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.credentials$key.size(); ++$i) {
                        credentials.put(this.credentials$key.get($i), this.credentials$value.get($i));
                    }
                    credentials = Collections.unmodifiableMap(credentials);
                }
            }
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<String>(this.tags));
                }
            }
            return new UnionServiceInstanceEntity(credentials, this.dashboardUrl, this.gatewayData, this.lastOperation, this.name, this.routeServiceUrl, this.routesUrl, this.serviceBindingsUrl, this.serviceKeysUrl, this.servicePlanId, this.servicePlanUrl, this.spaceId, this.spaceUrl, this.syslogDrainUrl, tags, this.type);
        }

        public String toString() {
            return "UnionServiceInstanceEntity.UnionServiceInstanceEntityBuilder(credentials$key=" + this.credentials$key + ", credentials$value=" + this.credentials$value + ", dashboardUrl=" + this.dashboardUrl + ", gatewayData=" + this.gatewayData + ", lastOperation=" + this.lastOperation + ", name=" + this.name + ", routeServiceUrl=" + this.routeServiceUrl + ", routesUrl=" + this.routesUrl + ", serviceBindingsUrl=" + this.serviceBindingsUrl + ", serviceKeysUrl=" + this.serviceKeysUrl + ", servicePlanId=" + this.servicePlanId + ", servicePlanUrl=" + this.servicePlanUrl + ", spaceId=" + this.spaceId + ", spaceUrl=" + this.spaceUrl + ", syslogDrainUrl=" + this.syslogDrainUrl + ", tags=" + this.tags + ", type=" + this.type + ")";
        }
    }
}

