/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicekeys;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CreateServiceKeyRequest
implements Validatable {
    private final String name;
    private final Map<String, Object> parameters;
    private final String serviceInstanceId;

    CreateServiceKeyRequest(String name, Map<String, Object> parameters, String serviceInstanceId) {
        this.name = name;
        this.parameters = parameters;
        this.serviceInstanceId = serviceInstanceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if (this.serviceInstanceId == null) {
            builder.message("service instance id must be specified");
        }
        return builder.build();
    }

    public static CreateServiceKeyRequestBuilder builder() {
        return new CreateServiceKeyRequestBuilder();
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="service_instance_guid")
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public static class CreateServiceKeyRequestBuilder {
        private String name;
        private ArrayList<String> parameters$key;
        private ArrayList<Object> parameters$value;
        private String serviceInstanceId;

        CreateServiceKeyRequestBuilder() {
        }

        public CreateServiceKeyRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateServiceKeyRequestBuilder parameter(String parameterKey, Object parameterValue) {
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            this.parameters$key.add(parameterKey);
            this.parameters$value.add(parameterValue);
            return this;
        }

        public CreateServiceKeyRequestBuilder parameters(Map<? extends String, ? extends Object> parameters) {
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : parameters.entrySet()) {
                this.parameters$key.add($lombokEntry.getKey());
                this.parameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CreateServiceKeyRequestBuilder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public CreateServiceKeyRequest build() {
            Map<String, Object> parameters;
            switch (this.parameters$key == null ? 0 : this.parameters$key.size()) {
                case 0: {
                    parameters = Collections.emptyMap();
                    break;
                }
                case 1: {
                    parameters = Collections.singletonMap(this.parameters$key.get(0), this.parameters$value.get(0));
                    break;
                }
                default: {
                    parameters = new LinkedHashMap(this.parameters$key.size() < 0x40000000 ? 1 + this.parameters$key.size() + (this.parameters$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.parameters$key.size(); ++$i) {
                        parameters.put(this.parameters$key.get($i), this.parameters$value.get($i));
                    }
                    parameters = Collections.unmodifiableMap(parameters);
                }
            }
            return new CreateServiceKeyRequest(this.name, parameters, this.serviceInstanceId);
        }

        public String toString() {
            return "CreateServiceKeyRequest.CreateServiceKeyRequestBuilder(name=" + this.name + ", parameters$key=" + this.parameters$key + ", parameters$value=" + this.parameters$value + ", serviceInstanceId=" + this.serviceInstanceId + ")";
        }
    }
}

