/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicekeys;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class DeleteServiceKeyRequest
implements Validatable {
    private final String serviceKeyId;

    DeleteServiceKeyRequest(String serviceKeyId) {
        this.serviceKeyId = serviceKeyId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceKeyId == null) {
            builder.message("service key id must be specified");
        }
        return builder.build();
    }

    public static DeleteServiceKeyRequestBuilder builder() {
        return new DeleteServiceKeyRequestBuilder();
    }

    @JsonIgnore
    public String getServiceKeyId() {
        return this.serviceKeyId;
    }

    public static class DeleteServiceKeyRequestBuilder {
        private String serviceKeyId;

        DeleteServiceKeyRequestBuilder() {
        }

        public DeleteServiceKeyRequestBuilder serviceKeyId(String serviceKeyId) {
            this.serviceKeyId = serviceKeyId;
            return this;
        }

        public DeleteServiceKeyRequest build() {
            return new DeleteServiceKeyRequest(this.serviceKeyId);
        }

        public String toString() {
            return "DeleteServiceKeyRequest.DeleteServiceKeyRequestBuilder(serviceKeyId=" + this.serviceKeyId + ")";
        }
    }
}

