/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicekeys;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListServiceKeysRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> names;
    private final List<String> serviceInstanceIds;

    ListServiceKeysRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> names, List<String> serviceInstanceIds) {
        super(orderDirection, page, resultsPerPage);
        this.names = names;
        this.serviceInstanceIds = serviceInstanceIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    public static ListServiceKeysRequestBuilder builder() {
        return new ListServiceKeysRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListServiceKeysRequest)) {
            return false;
        }
        ListServiceKeysRequest other = (ListServiceKeysRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        List<String> this$serviceInstanceIds = this.getServiceInstanceIds();
        List<String> other$serviceInstanceIds = other.getServiceInstanceIds();
        return !(this$serviceInstanceIds == null ? other$serviceInstanceIds != null : !((Object)this$serviceInstanceIds).equals(other$serviceInstanceIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListServiceKeysRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        List<String> $serviceInstanceIds = this.getServiceInstanceIds();
        result = result * 59 + ($serviceInstanceIds == null ? 43 : ((Object)$serviceInstanceIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListServiceKeysRequest(super=" + super.toString() + ", names=" + this.getNames() + ", serviceInstanceIds=" + this.getServiceInstanceIds() + ")";
    }

    @InFilterParameter(value="name")
    public List<String> getNames() {
        return this.names;
    }

    @InFilterParameter(value="service_instance_guid")
    public List<String> getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }

    public static class ListServiceKeysRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> names;
        private ArrayList<String> serviceInstanceIds;

        ListServiceKeysRequestBuilder() {
        }

        public ListServiceKeysRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListServiceKeysRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListServiceKeysRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListServiceKeysRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListServiceKeysRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListServiceKeysRequestBuilder serviceInstanceId(String serviceInstanceId) {
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList();
            }
            this.serviceInstanceIds.add(serviceInstanceId);
            return this;
        }

        public ListServiceKeysRequestBuilder serviceInstanceIds(Collection<? extends String> serviceInstanceIds) {
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList();
            }
            this.serviceInstanceIds.addAll(serviceInstanceIds);
            return this;
        }

        public ListServiceKeysRequest build() {
            List<String> serviceInstanceIds;
            List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            switch (this.serviceInstanceIds == null ? 0 : this.serviceInstanceIds.size()) {
                case 0: {
                    serviceInstanceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceInstanceIds = Collections.singletonList(this.serviceInstanceIds.get(0));
                    break;
                }
                default: {
                    serviceInstanceIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceInstanceIds));
                }
            }
            return new ListServiceKeysRequest(this.orderDirection, this.page, this.resultsPerPage, names, serviceInstanceIds);
        }

        public String toString() {
            return "ListServiceKeysRequest.ListServiceKeysRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", names=" + this.names + ", serviceInstanceIds=" + this.serviceInstanceIds + ")";
        }
    }
}

