/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicekeys;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public final class ServiceKeyEntity {
    private final Map<String, Object> credentials;
    private final String name;
    private final String serviceInstanceId;
    private final String serviceInstanceUrl;

    ServiceKeyEntity(@JsonProperty(value="credentials") Map<String, Object> credentials, @JsonProperty(value="name") String name, @JsonProperty(value="service_instance_guid") String serviceInstanceId, @JsonProperty(value="service_instance_url") String serviceInstanceUrl) {
        this.credentials = Optional.ofNullable(credentials).orElse(Collections.emptyMap());
        this.name = name;
        this.serviceInstanceId = serviceInstanceId;
        this.serviceInstanceUrl = serviceInstanceUrl;
    }

    public static ServiceKeyEntityBuilder builder() {
        return new ServiceKeyEntityBuilder();
    }

    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public String getServiceInstanceUrl() {
        return this.serviceInstanceUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceKeyEntity)) {
            return false;
        }
        ServiceKeyEntity other = (ServiceKeyEntity)o;
        Map<String, Object> this$credentials = this.getCredentials();
        Map<String, Object> other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$serviceInstanceId = this.getServiceInstanceId();
        String other$serviceInstanceId = other.getServiceInstanceId();
        if (this$serviceInstanceId == null ? other$serviceInstanceId != null : !this$serviceInstanceId.equals(other$serviceInstanceId)) {
            return false;
        }
        String this$serviceInstanceUrl = this.getServiceInstanceUrl();
        String other$serviceInstanceUrl = other.getServiceInstanceUrl();
        return !(this$serviceInstanceUrl == null ? other$serviceInstanceUrl != null : !this$serviceInstanceUrl.equals(other$serviceInstanceUrl));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $serviceInstanceId = this.getServiceInstanceId();
        result = result * 59 + ($serviceInstanceId == null ? 43 : $serviceInstanceId.hashCode());
        String $serviceInstanceUrl = this.getServiceInstanceUrl();
        result = result * 59 + ($serviceInstanceUrl == null ? 43 : $serviceInstanceUrl.hashCode());
        return result;
    }

    public String toString() {
        return "ServiceKeyEntity(credentials=" + this.getCredentials() + ", name=" + this.getName() + ", serviceInstanceId=" + this.getServiceInstanceId() + ", serviceInstanceUrl=" + this.getServiceInstanceUrl() + ")";
    }

    public static class ServiceKeyEntityBuilder {
        private ArrayList<String> credentials$key;
        private ArrayList<Object> credentials$value;
        private String name;
        private String serviceInstanceId;
        private String serviceInstanceUrl;

        ServiceKeyEntityBuilder() {
        }

        public ServiceKeyEntityBuilder credential(String credentialKey, Object credentialValue) {
            if (this.credentials$key == null) {
                this.credentials$key = new ArrayList();
                this.credentials$value = new ArrayList();
            }
            this.credentials$key.add(credentialKey);
            this.credentials$value.add(credentialValue);
            return this;
        }

        public ServiceKeyEntityBuilder credentials(Map<? extends String, ? extends Object> credentials) {
            if (this.credentials$key == null) {
                this.credentials$key = new ArrayList();
                this.credentials$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : credentials.entrySet()) {
                this.credentials$key.add($lombokEntry.getKey());
                this.credentials$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ServiceKeyEntityBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ServiceKeyEntityBuilder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public ServiceKeyEntityBuilder serviceInstanceUrl(String serviceInstanceUrl) {
            this.serviceInstanceUrl = serviceInstanceUrl;
            return this;
        }

        public ServiceKeyEntity build() {
            Map<String, Object> credentials;
            switch (this.credentials$key == null ? 0 : this.credentials$key.size()) {
                case 0: {
                    credentials = Collections.emptyMap();
                    break;
                }
                case 1: {
                    credentials = Collections.singletonMap(this.credentials$key.get(0), this.credentials$value.get(0));
                    break;
                }
                default: {
                    credentials = new LinkedHashMap(this.credentials$key.size() < 0x40000000 ? 1 + this.credentials$key.size() + (this.credentials$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.credentials$key.size(); ++$i) {
                        credentials.put(this.credentials$key.get($i), this.credentials$value.get($i));
                    }
                    credentials = Collections.unmodifiableMap(credentials);
                }
            }
            return new ServiceKeyEntity(credentials, this.name, this.serviceInstanceId, this.serviceInstanceUrl);
        }

        public String toString() {
            return "ServiceKeyEntity.ServiceKeyEntityBuilder(credentials$key=" + this.credentials$key + ", credentials$value=" + this.credentials$value + ", name=" + this.name + ", serviceInstanceId=" + this.serviceInstanceId + ", serviceInstanceUrl=" + this.serviceInstanceUrl + ")";
        }
    }
}

