/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class DeleteServicePlanRequest
implements Validatable {
    private final Boolean async;
    private final String servicePlanId;

    DeleteServicePlanRequest(Boolean async, String servicePlanId) {
        this.async = async;
        this.servicePlanId = servicePlanId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.servicePlanId == null) {
            builder.message("service plan id must be specified");
        }
        return builder.build();
    }

    public static DeleteServicePlanRequestBuilder builder() {
        return new DeleteServicePlanRequestBuilder();
    }

    @QueryParameter(value="async")
    public Boolean getAsync() {
        return this.async;
    }

    @JsonIgnore
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    public static class DeleteServicePlanRequestBuilder {
        private Boolean async;
        private String servicePlanId;

        DeleteServicePlanRequestBuilder() {
        }

        public DeleteServicePlanRequestBuilder async(Boolean async) {
            this.async = async;
            return this;
        }

        public DeleteServicePlanRequestBuilder servicePlanId(String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        public DeleteServicePlanRequest build() {
            return new DeleteServicePlanRequest(this.async, this.servicePlanId);
        }

        public String toString() {
            return "DeleteServicePlanRequest.DeleteServicePlanRequestBuilder(async=" + this.async + ", servicePlanId=" + this.servicePlanId + ")";
        }
    }
}

