/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class GetServicePlanRequest
implements Validatable {
    private final String servicePlanId;

    GetServicePlanRequest(String servicePlanId) {
        this.servicePlanId = servicePlanId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.servicePlanId == null) {
            builder.message("service plan id must be specified");
        }
        return builder.build();
    }

    public static GetServicePlanRequestBuilder builder() {
        return new GetServicePlanRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetServicePlanRequest)) {
            return false;
        }
        GetServicePlanRequest other = (GetServicePlanRequest)o;
        String this$servicePlanId = this.getServicePlanId();
        String other$servicePlanId = other.getServicePlanId();
        return !(this$servicePlanId == null ? other$servicePlanId != null : !this$servicePlanId.equals(other$servicePlanId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $servicePlanId = this.getServicePlanId();
        result = result * 59 + ($servicePlanId == null ? 43 : $servicePlanId.hashCode());
        return result;
    }

    public String toString() {
        return "GetServicePlanRequest(servicePlanId=" + this.getServicePlanId() + ")";
    }

    @JsonIgnore
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    public static class GetServicePlanRequestBuilder {
        private String servicePlanId;

        GetServicePlanRequestBuilder() {
        }

        public GetServicePlanRequestBuilder servicePlanId(String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        public GetServicePlanRequest build() {
            return new GetServicePlanRequest(this.servicePlanId);
        }

        public String toString() {
            return "GetServicePlanRequest.GetServicePlanRequestBuilder(servicePlanId=" + this.servicePlanId + ")";
        }
    }
}

