/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListServicePlanServiceInstancesRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> gatewayNames;
    private final List<String> names;
    private final List<String> serviceBindingIds;
    private final List<String> serviceKeyIds;
    private final String servicePlanId;
    private final List<String> spaceIds;

    ListServicePlanServiceInstancesRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> gatewayNames, List<String> names, List<String> serviceBindingIds, List<String> serviceKeyIds, String servicePlanId, List<String> spaceIds) {
        super(orderDirection, page, resultsPerPage);
        this.gatewayNames = gatewayNames;
        this.names = names;
        this.serviceBindingIds = serviceBindingIds;
        this.serviceKeyIds = serviceKeyIds;
        this.servicePlanId = servicePlanId;
        this.spaceIds = spaceIds;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.servicePlanId == null) {
            builder.message("service plan id must be specified");
        }
        return builder.build();
    }

    public static ListServicePlanServiceInstancesRequestBuilder builder() {
        return new ListServicePlanServiceInstancesRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListServicePlanServiceInstancesRequest)) {
            return false;
        }
        ListServicePlanServiceInstancesRequest other = (ListServicePlanServiceInstancesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$gatewayNames = this.getGatewayNames();
        List<String> other$gatewayNames = other.getGatewayNames();
        if (this$gatewayNames == null ? other$gatewayNames != null : !((Object)this$gatewayNames).equals(other$gatewayNames)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        List<String> this$serviceBindingIds = this.getServiceBindingIds();
        List<String> other$serviceBindingIds = other.getServiceBindingIds();
        if (this$serviceBindingIds == null ? other$serviceBindingIds != null : !((Object)this$serviceBindingIds).equals(other$serviceBindingIds)) {
            return false;
        }
        List<String> this$serviceKeyIds = this.getServiceKeyIds();
        List<String> other$serviceKeyIds = other.getServiceKeyIds();
        if (this$serviceKeyIds == null ? other$serviceKeyIds != null : !((Object)this$serviceKeyIds).equals(other$serviceKeyIds)) {
            return false;
        }
        String this$servicePlanId = this.getServicePlanId();
        String other$servicePlanId = other.getServicePlanId();
        if (this$servicePlanId == null ? other$servicePlanId != null : !this$servicePlanId.equals(other$servicePlanId)) {
            return false;
        }
        List<String> this$spaceIds = this.getSpaceIds();
        List<String> other$spaceIds = other.getSpaceIds();
        return !(this$spaceIds == null ? other$spaceIds != null : !((Object)this$spaceIds).equals(other$spaceIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListServicePlanServiceInstancesRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $gatewayNames = this.getGatewayNames();
        result = result * 59 + ($gatewayNames == null ? 43 : ((Object)$gatewayNames).hashCode());
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        List<String> $serviceBindingIds = this.getServiceBindingIds();
        result = result * 59 + ($serviceBindingIds == null ? 43 : ((Object)$serviceBindingIds).hashCode());
        List<String> $serviceKeyIds = this.getServiceKeyIds();
        result = result * 59 + ($serviceKeyIds == null ? 43 : ((Object)$serviceKeyIds).hashCode());
        String $servicePlanId = this.getServicePlanId();
        result = result * 59 + ($servicePlanId == null ? 43 : $servicePlanId.hashCode());
        List<String> $spaceIds = this.getSpaceIds();
        result = result * 59 + ($spaceIds == null ? 43 : ((Object)$spaceIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListServicePlanServiceInstancesRequest(super=" + super.toString() + ", gatewayNames=" + this.getGatewayNames() + ", names=" + this.getNames() + ", serviceBindingIds=" + this.getServiceBindingIds() + ", serviceKeyIds=" + this.getServiceKeyIds() + ", servicePlanId=" + this.getServicePlanId() + ", spaceIds=" + this.getSpaceIds() + ")";
    }

    @InFilterParameter(value="gateway_name")
    public List<String> getGatewayNames() {
        return this.gatewayNames;
    }

    @InFilterParameter(value="names")
    public List<String> getNames() {
        return this.names;
    }

    @InFilterParameter(value="service_binding_guid")
    public List<String> getServiceBindingIds() {
        return this.serviceBindingIds;
    }

    @InFilterParameter(value="service_key_guid")
    public List<String> getServiceKeyIds() {
        return this.serviceKeyIds;
    }

    @JsonIgnore
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    @InFilterParameter(value="space_guid")
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    public static class ListServicePlanServiceInstancesRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> gatewayNames;
        private ArrayList<String> names;
        private ArrayList<String> serviceBindingIds;
        private ArrayList<String> serviceKeyIds;
        private String servicePlanId;
        private ArrayList<String> spaceIds;

        ListServicePlanServiceInstancesRequestBuilder() {
        }

        public ListServicePlanServiceInstancesRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListServicePlanServiceInstancesRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListServicePlanServiceInstancesRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListServicePlanServiceInstancesRequestBuilder gatewayName(String gatewayName) {
            if (this.gatewayNames == null) {
                this.gatewayNames = new ArrayList();
            }
            this.gatewayNames.add(gatewayName);
            return this;
        }

        public ListServicePlanServiceInstancesRequestBuilder gatewayNames(Collection<? extends String> gatewayNames) {
            if (this.gatewayNames == null) {
                this.gatewayNames = new ArrayList();
            }
            this.gatewayNames.addAll(gatewayNames);
            return this;
        }

        public ListServicePlanServiceInstancesRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListServicePlanServiceInstancesRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListServicePlanServiceInstancesRequestBuilder serviceBindingId(String serviceBindingId) {
            if (this.serviceBindingIds == null) {
                this.serviceBindingIds = new ArrayList();
            }
            this.serviceBindingIds.add(serviceBindingId);
            return this;
        }

        public ListServicePlanServiceInstancesRequestBuilder serviceBindingIds(Collection<? extends String> serviceBindingIds) {
            if (this.serviceBindingIds == null) {
                this.serviceBindingIds = new ArrayList();
            }
            this.serviceBindingIds.addAll(serviceBindingIds);
            return this;
        }

        public ListServicePlanServiceInstancesRequestBuilder serviceKeyId(String serviceKeyId) {
            if (this.serviceKeyIds == null) {
                this.serviceKeyIds = new ArrayList();
            }
            this.serviceKeyIds.add(serviceKeyId);
            return this;
        }

        public ListServicePlanServiceInstancesRequestBuilder serviceKeyIds(Collection<? extends String> serviceKeyIds) {
            if (this.serviceKeyIds == null) {
                this.serviceKeyIds = new ArrayList();
            }
            this.serviceKeyIds.addAll(serviceKeyIds);
            return this;
        }

        public ListServicePlanServiceInstancesRequestBuilder servicePlanId(String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        public ListServicePlanServiceInstancesRequestBuilder spaceId(String spaceId) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList();
            }
            this.spaceIds.add(spaceId);
            return this;
        }

        public ListServicePlanServiceInstancesRequestBuilder spaceIds(Collection<? extends String> spaceIds) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList();
            }
            this.spaceIds.addAll(spaceIds);
            return this;
        }

        public ListServicePlanServiceInstancesRequest build() {
            List<String> spaceIds;
            List<String> serviceKeyIds;
            List<String> serviceBindingIds;
            List<String> names;
            List<String> gatewayNames;
            switch (this.gatewayNames == null ? 0 : this.gatewayNames.size()) {
                case 0: {
                    gatewayNames = Collections.emptyList();
                    break;
                }
                case 1: {
                    gatewayNames = Collections.singletonList(this.gatewayNames.get(0));
                    break;
                }
                default: {
                    gatewayNames = Collections.unmodifiableList(new ArrayList<String>(this.gatewayNames));
                }
            }
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            switch (this.serviceBindingIds == null ? 0 : this.serviceBindingIds.size()) {
                case 0: {
                    serviceBindingIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceBindingIds = Collections.singletonList(this.serviceBindingIds.get(0));
                    break;
                }
                default: {
                    serviceBindingIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceBindingIds));
                }
            }
            switch (this.serviceKeyIds == null ? 0 : this.serviceKeyIds.size()) {
                case 0: {
                    serviceKeyIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceKeyIds = Collections.singletonList(this.serviceKeyIds.get(0));
                    break;
                }
                default: {
                    serviceKeyIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceKeyIds));
                }
            }
            switch (this.spaceIds == null ? 0 : this.spaceIds.size()) {
                case 0: {
                    spaceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    spaceIds = Collections.singletonList(this.spaceIds.get(0));
                    break;
                }
                default: {
                    spaceIds = Collections.unmodifiableList(new ArrayList<String>(this.spaceIds));
                }
            }
            return new ListServicePlanServiceInstancesRequest(this.orderDirection, this.page, this.resultsPerPage, gatewayNames, names, serviceBindingIds, serviceKeyIds, this.servicePlanId, spaceIds);
        }

        public String toString() {
            return "ListServicePlanServiceInstancesRequest.ListServicePlanServiceInstancesRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", gatewayNames=" + this.gatewayNames + ", names=" + this.names + ", serviceBindingIds=" + this.serviceBindingIds + ", serviceKeyIds=" + this.serviceKeyIds + ", servicePlanId=" + this.servicePlanId + ", spaceIds=" + this.spaceIds + ")";
        }
    }
}

