/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.serviceinstances.ServiceInstanceResource;

public final class ListServicePlanServiceInstancesResponse
extends PaginatedResponse<ServiceInstanceResource> {
    ListServicePlanServiceInstancesResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<ServiceInstanceResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListServicePlanServiceInstancesResponseBuilder builder() {
        return new ListServicePlanServiceInstancesResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListServicePlanServiceInstancesResponse)) {
            return false;
        }
        ListServicePlanServiceInstancesResponse other = (ListServicePlanServiceInstancesResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListServicePlanServiceInstancesResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListServicePlanServiceInstancesResponse(super=" + super.toString() + ")";
    }

    public static class ListServicePlanServiceInstancesResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<ServiceInstanceResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListServicePlanServiceInstancesResponseBuilder() {
        }

        public ListServicePlanServiceInstancesResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListServicePlanServiceInstancesResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListServicePlanServiceInstancesResponseBuilder resource(ServiceInstanceResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListServicePlanServiceInstancesResponseBuilder resources(Collection<? extends ServiceInstanceResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListServicePlanServiceInstancesResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListServicePlanServiceInstancesResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListServicePlanServiceInstancesResponse build() {
            List<ServiceInstanceResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<ServiceInstanceResource>(this.resources));
                }
            }
            return new ListServicePlanServiceInstancesResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListServicePlanServiceInstancesResponse.ListServicePlanServiceInstancesResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

