/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListServicePlansRequest
extends PaginatedRequest
implements Validatable {
    private final Boolean active;
    private final List<String> serviceBrokerIds;
    private final List<String> serviceIds;
    private final List<String> serviceInstanceIds;

    ListServicePlansRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, Boolean active, List<String> serviceBrokerIds, List<String> serviceIds, List<String> serviceInstanceIds) {
        super(orderDirection, page, resultsPerPage);
        this.active = active;
        this.serviceBrokerIds = serviceBrokerIds;
        this.serviceIds = serviceIds;
        this.serviceInstanceIds = serviceInstanceIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    public static ListServicePlansRequestBuilder builder() {
        return new ListServicePlansRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListServicePlansRequest)) {
            return false;
        }
        ListServicePlansRequest other = (ListServicePlansRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        List<String> this$serviceBrokerIds = this.getServiceBrokerIds();
        List<String> other$serviceBrokerIds = other.getServiceBrokerIds();
        if (this$serviceBrokerIds == null ? other$serviceBrokerIds != null : !((Object)this$serviceBrokerIds).equals(other$serviceBrokerIds)) {
            return false;
        }
        List<String> this$serviceIds = this.getServiceIds();
        List<String> other$serviceIds = other.getServiceIds();
        if (this$serviceIds == null ? other$serviceIds != null : !((Object)this$serviceIds).equals(other$serviceIds)) {
            return false;
        }
        List<String> this$serviceInstanceIds = this.getServiceInstanceIds();
        List<String> other$serviceInstanceIds = other.getServiceInstanceIds();
        return !(this$serviceInstanceIds == null ? other$serviceInstanceIds != null : !((Object)this$serviceInstanceIds).equals(other$serviceInstanceIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListServicePlansRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        List<String> $serviceBrokerIds = this.getServiceBrokerIds();
        result = result * 59 + ($serviceBrokerIds == null ? 43 : ((Object)$serviceBrokerIds).hashCode());
        List<String> $serviceIds = this.getServiceIds();
        result = result * 59 + ($serviceIds == null ? 43 : ((Object)$serviceIds).hashCode());
        List<String> $serviceInstanceIds = this.getServiceInstanceIds();
        result = result * 59 + ($serviceInstanceIds == null ? 43 : ((Object)$serviceInstanceIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListServicePlansRequest(super=" + super.toString() + ", active=" + this.getActive() + ", serviceBrokerIds=" + this.getServiceBrokerIds() + ", serviceIds=" + this.getServiceIds() + ", serviceInstanceIds=" + this.getServiceInstanceIds() + ")";
    }

    @InFilterParameter(value="active")
    public Boolean getActive() {
        return this.active;
    }

    @InFilterParameter(value="service_broker_guid")
    public List<String> getServiceBrokerIds() {
        return this.serviceBrokerIds;
    }

    @InFilterParameter(value="service_guid")
    public List<String> getServiceIds() {
        return this.serviceIds;
    }

    @InFilterParameter(value="service_instance_guid")
    public List<String> getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }

    public static class ListServicePlansRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private Boolean active;
        private ArrayList<String> serviceBrokerIds;
        private ArrayList<String> serviceIds;
        private ArrayList<String> serviceInstanceIds;

        ListServicePlansRequestBuilder() {
        }

        public ListServicePlansRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListServicePlansRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListServicePlansRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListServicePlansRequestBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public ListServicePlansRequestBuilder serviceBrokerId(String serviceBrokerId) {
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList();
            }
            this.serviceBrokerIds.add(serviceBrokerId);
            return this;
        }

        public ListServicePlansRequestBuilder serviceBrokerIds(Collection<? extends String> serviceBrokerIds) {
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList();
            }
            this.serviceBrokerIds.addAll(serviceBrokerIds);
            return this;
        }

        public ListServicePlansRequestBuilder serviceId(String serviceId) {
            if (this.serviceIds == null) {
                this.serviceIds = new ArrayList();
            }
            this.serviceIds.add(serviceId);
            return this;
        }

        public ListServicePlansRequestBuilder serviceIds(Collection<? extends String> serviceIds) {
            if (this.serviceIds == null) {
                this.serviceIds = new ArrayList();
            }
            this.serviceIds.addAll(serviceIds);
            return this;
        }

        public ListServicePlansRequestBuilder serviceInstanceId(String serviceInstanceId) {
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList();
            }
            this.serviceInstanceIds.add(serviceInstanceId);
            return this;
        }

        public ListServicePlansRequestBuilder serviceInstanceIds(Collection<? extends String> serviceInstanceIds) {
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList();
            }
            this.serviceInstanceIds.addAll(serviceInstanceIds);
            return this;
        }

        public ListServicePlansRequest build() {
            List<String> serviceInstanceIds;
            List<String> serviceIds;
            List<String> serviceBrokerIds;
            switch (this.serviceBrokerIds == null ? 0 : this.serviceBrokerIds.size()) {
                case 0: {
                    serviceBrokerIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceBrokerIds = Collections.singletonList(this.serviceBrokerIds.get(0));
                    break;
                }
                default: {
                    serviceBrokerIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceBrokerIds));
                }
            }
            switch (this.serviceIds == null ? 0 : this.serviceIds.size()) {
                case 0: {
                    serviceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceIds = Collections.singletonList(this.serviceIds.get(0));
                    break;
                }
                default: {
                    serviceIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceIds));
                }
            }
            switch (this.serviceInstanceIds == null ? 0 : this.serviceInstanceIds.size()) {
                case 0: {
                    serviceInstanceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceInstanceIds = Collections.singletonList(this.serviceInstanceIds.get(0));
                    break;
                }
                default: {
                    serviceInstanceIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceInstanceIds));
                }
            }
            return new ListServicePlansRequest(this.orderDirection, this.page, this.resultsPerPage, this.active, serviceBrokerIds, serviceIds, serviceInstanceIds);
        }

        public String toString() {
            return "ListServicePlansRequest.ListServicePlansRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", active=" + this.active + ", serviceBrokerIds=" + this.serviceBrokerIds + ", serviceIds=" + this.serviceIds + ", serviceInstanceIds=" + this.serviceInstanceIds + ")";
        }
    }
}

