/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class MigrateServiceInstancesRequest
implements Validatable {
    private final String currentServicePlanId;
    private final String destinationServicePlanId;

    MigrateServiceInstancesRequest(String currentServicePlanId, String destinationServicePlanId) {
        this.currentServicePlanId = currentServicePlanId;
        this.destinationServicePlanId = destinationServicePlanId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.currentServicePlanId == null) {
            builder.message("current service plan id must be specified");
        }
        if (this.destinationServicePlanId == null) {
            builder.message("destination service plan id must be specified");
        }
        return builder.build();
    }

    public static MigrateServiceInstancesRequestBuilder builder() {
        return new MigrateServiceInstancesRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrateServiceInstancesRequest)) {
            return false;
        }
        MigrateServiceInstancesRequest other = (MigrateServiceInstancesRequest)o;
        String this$currentServicePlanId = this.getCurrentServicePlanId();
        String other$currentServicePlanId = other.getCurrentServicePlanId();
        if (this$currentServicePlanId == null ? other$currentServicePlanId != null : !this$currentServicePlanId.equals(other$currentServicePlanId)) {
            return false;
        }
        String this$destinationServicePlanId = this.getDestinationServicePlanId();
        String other$destinationServicePlanId = other.getDestinationServicePlanId();
        return !(this$destinationServicePlanId == null ? other$destinationServicePlanId != null : !this$destinationServicePlanId.equals(other$destinationServicePlanId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $currentServicePlanId = this.getCurrentServicePlanId();
        result = result * 59 + ($currentServicePlanId == null ? 43 : $currentServicePlanId.hashCode());
        String $destinationServicePlanId = this.getDestinationServicePlanId();
        result = result * 59 + ($destinationServicePlanId == null ? 43 : $destinationServicePlanId.hashCode());
        return result;
    }

    public String toString() {
        return "MigrateServiceInstancesRequest(currentServicePlanId=" + this.getCurrentServicePlanId() + ", destinationServicePlanId=" + this.getDestinationServicePlanId() + ")";
    }

    @JsonIgnore
    public String getCurrentServicePlanId() {
        return this.currentServicePlanId;
    }

    @JsonProperty(value="service_plan_guid")
    public String getDestinationServicePlanId() {
        return this.destinationServicePlanId;
    }

    public static class MigrateServiceInstancesRequestBuilder {
        private String currentServicePlanId;
        private String destinationServicePlanId;

        MigrateServiceInstancesRequestBuilder() {
        }

        public MigrateServiceInstancesRequestBuilder currentServicePlanId(String currentServicePlanId) {
            this.currentServicePlanId = currentServicePlanId;
            return this;
        }

        public MigrateServiceInstancesRequestBuilder destinationServicePlanId(String destinationServicePlanId) {
            this.destinationServicePlanId = destinationServicePlanId;
            return this;
        }

        public MigrateServiceInstancesRequest build() {
            return new MigrateServiceInstancesRequest(this.currentServicePlanId, this.destinationServicePlanId);
        }

        public String toString() {
            return "MigrateServiceInstancesRequest.MigrateServiceInstancesRequestBuilder(currentServicePlanId=" + this.currentServicePlanId + ", destinationServicePlanId=" + this.destinationServicePlanId + ")";
        }
    }
}

