/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class UpdateServicePlanRequest
implements Validatable {
    private final Boolean publiclyVisible;
    private final String servicePlanId;

    UpdateServicePlanRequest(Boolean publiclyVisible, String servicePlanId) {
        this.publiclyVisible = publiclyVisible;
        this.servicePlanId = servicePlanId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.servicePlanId == null) {
            builder.message("service plan id must be specified");
        }
        return builder.build();
    }

    public static UpdateServicePlanRequestBuilder builder() {
        return new UpdateServicePlanRequestBuilder();
    }

    @JsonProperty(value="public")
    public Boolean getPubliclyVisible() {
        return this.publiclyVisible;
    }

    @JsonIgnore
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    public static class UpdateServicePlanRequestBuilder {
        private Boolean publiclyVisible;
        private String servicePlanId;

        UpdateServicePlanRequestBuilder() {
        }

        public UpdateServicePlanRequestBuilder publiclyVisible(Boolean publiclyVisible) {
            this.publiclyVisible = publiclyVisible;
            return this;
        }

        public UpdateServicePlanRequestBuilder servicePlanId(String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        public UpdateServicePlanRequest build() {
            return new UpdateServicePlanRequest(this.publiclyVisible, this.servicePlanId);
        }

        public String toString() {
            return "UpdateServicePlanRequest.UpdateServicePlanRequestBuilder(publiclyVisible=" + this.publiclyVisible + ", servicePlanId=" + this.servicePlanId + ")";
        }
    }
}

