/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplanvisibilities;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CreateServicePlanVisibilityRequest
implements Validatable {
    private final String organizationId;
    private final String servicePlanId;

    CreateServicePlanVisibilityRequest(String organizationId, String servicePlanId) {
        this.organizationId = organizationId;
        this.servicePlanId = servicePlanId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        if (this.servicePlanId == null) {
            builder.message("service plan id must be specified");
        }
        return builder.build();
    }

    public static CreateServicePlanVisibilityRequestBuilder builder() {
        return new CreateServicePlanVisibilityRequestBuilder();
    }

    @JsonProperty(value="organization_guid")
    public String getOrganizationId() {
        return this.organizationId;
    }

    @JsonProperty(value="service_plan_guid")
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    public static class CreateServicePlanVisibilityRequestBuilder {
        private String organizationId;
        private String servicePlanId;

        CreateServicePlanVisibilityRequestBuilder() {
        }

        public CreateServicePlanVisibilityRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public CreateServicePlanVisibilityRequestBuilder servicePlanId(String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        public CreateServicePlanVisibilityRequest build() {
            return new CreateServicePlanVisibilityRequest(this.organizationId, this.servicePlanId);
        }

        public String toString() {
            return "CreateServicePlanVisibilityRequest.CreateServicePlanVisibilityRequestBuilder(organizationId=" + this.organizationId + ", servicePlanId=" + this.servicePlanId + ")";
        }
    }
}

