/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplanvisibilities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class DeleteServicePlanVisibilityRequest
implements Validatable {
    private final Boolean async;
    private final String servicePlanVisibilityId;

    DeleteServicePlanVisibilityRequest(Boolean async, String servicePlanVisibilityId) {
        this.async = async;
        this.servicePlanVisibilityId = servicePlanVisibilityId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.servicePlanVisibilityId == null) {
            builder.message("service plan visibility id must be specified");
        }
        return builder.build();
    }

    public static DeleteServicePlanVisibilityRequestBuilder builder() {
        return new DeleteServicePlanVisibilityRequestBuilder();
    }

    @QueryParameter(value="async")
    public Boolean getAsync() {
        return this.async;
    }

    @JsonIgnore
    public String getServicePlanVisibilityId() {
        return this.servicePlanVisibilityId;
    }

    public static class DeleteServicePlanVisibilityRequestBuilder {
        private Boolean async;
        private String servicePlanVisibilityId;

        DeleteServicePlanVisibilityRequestBuilder() {
        }

        public DeleteServicePlanVisibilityRequestBuilder async(Boolean async) {
            this.async = async;
            return this;
        }

        public DeleteServicePlanVisibilityRequestBuilder servicePlanVisibilityId(String servicePlanVisibilityId) {
            this.servicePlanVisibilityId = servicePlanVisibilityId;
            return this;
        }

        public DeleteServicePlanVisibilityRequest build() {
            return new DeleteServicePlanVisibilityRequest(this.async, this.servicePlanVisibilityId);
        }

        public String toString() {
            return "DeleteServicePlanVisibilityRequest.DeleteServicePlanVisibilityRequestBuilder(async=" + this.async + ", servicePlanVisibilityId=" + this.servicePlanVisibilityId + ")";
        }
    }
}

