/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplanvisibilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListServicePlanVisibilitiesRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> organizationIds;
    private final List<String> servicePlanIds;

    ListServicePlanVisibilitiesRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> organizationIds, List<String> servicePlanIds) {
        super(orderDirection, page, resultsPerPage);
        this.organizationIds = organizationIds;
        this.servicePlanIds = servicePlanIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    public static ListServicePlanVisibilitiesRequestBuilder builder() {
        return new ListServicePlanVisibilitiesRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListServicePlanVisibilitiesRequest)) {
            return false;
        }
        ListServicePlanVisibilitiesRequest other = (ListServicePlanVisibilitiesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$organizationIds = this.getOrganizationIds();
        List<String> other$organizationIds = other.getOrganizationIds();
        if (this$organizationIds == null ? other$organizationIds != null : !((Object)this$organizationIds).equals(other$organizationIds)) {
            return false;
        }
        List<String> this$servicePlanIds = this.getServicePlanIds();
        List<String> other$servicePlanIds = other.getServicePlanIds();
        return !(this$servicePlanIds == null ? other$servicePlanIds != null : !((Object)this$servicePlanIds).equals(other$servicePlanIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListServicePlanVisibilitiesRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $organizationIds = this.getOrganizationIds();
        result = result * 59 + ($organizationIds == null ? 43 : ((Object)$organizationIds).hashCode());
        List<String> $servicePlanIds = this.getServicePlanIds();
        result = result * 59 + ($servicePlanIds == null ? 43 : ((Object)$servicePlanIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListServicePlanVisibilitiesRequest(super=" + super.toString() + ", organizationIds=" + this.getOrganizationIds() + ", servicePlanIds=" + this.getServicePlanIds() + ")";
    }

    @InFilterParameter(value="organization_guid")
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @InFilterParameter(value="service_plan_guid")
    public List<String> getServicePlanIds() {
        return this.servicePlanIds;
    }

    public static class ListServicePlanVisibilitiesRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> organizationIds;
        private ArrayList<String> servicePlanIds;

        ListServicePlanVisibilitiesRequestBuilder() {
        }

        public ListServicePlanVisibilitiesRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListServicePlanVisibilitiesRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListServicePlanVisibilitiesRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListServicePlanVisibilitiesRequestBuilder organizationId(String organizationId) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.add(organizationId);
            return this;
        }

        public ListServicePlanVisibilitiesRequestBuilder organizationIds(Collection<? extends String> organizationIds) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.addAll(organizationIds);
            return this;
        }

        public ListServicePlanVisibilitiesRequestBuilder servicePlanId(String servicePlanId) {
            if (this.servicePlanIds == null) {
                this.servicePlanIds = new ArrayList();
            }
            this.servicePlanIds.add(servicePlanId);
            return this;
        }

        public ListServicePlanVisibilitiesRequestBuilder servicePlanIds(Collection<? extends String> servicePlanIds) {
            if (this.servicePlanIds == null) {
                this.servicePlanIds = new ArrayList();
            }
            this.servicePlanIds.addAll(servicePlanIds);
            return this;
        }

        public ListServicePlanVisibilitiesRequest build() {
            List<String> servicePlanIds;
            List<String> organizationIds;
            switch (this.organizationIds == null ? 0 : this.organizationIds.size()) {
                case 0: {
                    organizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    organizationIds = Collections.singletonList(this.organizationIds.get(0));
                    break;
                }
                default: {
                    organizationIds = Collections.unmodifiableList(new ArrayList<String>(this.organizationIds));
                }
            }
            switch (this.servicePlanIds == null ? 0 : this.servicePlanIds.size()) {
                case 0: {
                    servicePlanIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    servicePlanIds = Collections.singletonList(this.servicePlanIds.get(0));
                    break;
                }
                default: {
                    servicePlanIds = Collections.unmodifiableList(new ArrayList<String>(this.servicePlanIds));
                }
            }
            return new ListServicePlanVisibilitiesRequest(this.orderDirection, this.page, this.resultsPerPage, organizationIds, servicePlanIds);
        }

        public String toString() {
            return "ListServicePlanVisibilitiesRequest.ListServicePlanVisibilitiesRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", organizationIds=" + this.organizationIds + ", servicePlanIds=" + this.servicePlanIds + ")";
        }
    }
}

