/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplanvisibilities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.serviceplanvisibilities.ServicePlanVisibilityResource;

public final class ListServicePlanVisibilitiesResponse
extends PaginatedResponse<ServicePlanVisibilityResource> {
    ListServicePlanVisibilitiesResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<ServicePlanVisibilityResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListServicePlanVisibilitiesResponseBuilder builder() {
        return new ListServicePlanVisibilitiesResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListServicePlanVisibilitiesResponse)) {
            return false;
        }
        ListServicePlanVisibilitiesResponse other = (ListServicePlanVisibilitiesResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListServicePlanVisibilitiesResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListServicePlanVisibilitiesResponse(super=" + super.toString() + ")";
    }

    public static class ListServicePlanVisibilitiesResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<ServicePlanVisibilityResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListServicePlanVisibilitiesResponseBuilder() {
        }

        public ListServicePlanVisibilitiesResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListServicePlanVisibilitiesResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListServicePlanVisibilitiesResponseBuilder resource(ServicePlanVisibilityResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListServicePlanVisibilitiesResponseBuilder resources(Collection<? extends ServicePlanVisibilityResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListServicePlanVisibilitiesResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListServicePlanVisibilitiesResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListServicePlanVisibilitiesResponse build() {
            List<ServicePlanVisibilityResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<ServicePlanVisibilityResource>(this.resources));
                }
            }
            return new ListServicePlanVisibilitiesResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListServicePlanVisibilitiesResponse.ListServicePlanVisibilitiesResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

