/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplanvisibilities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class UpdateServicePlanVisibilityRequest
implements Validatable {
    private final String organizationId;
    private final String servicePlanId;
    private final String servicePlanVisibilityId;

    UpdateServicePlanVisibilityRequest(String organizationId, String servicePlanId, String servicePlanVisibilityId) {
        this.organizationId = organizationId;
        this.servicePlanId = servicePlanId;
        this.servicePlanVisibilityId = servicePlanVisibilityId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        if (this.servicePlanId == null) {
            builder.message("service plan id must be specified");
        }
        if (this.servicePlanVisibilityId == null) {
            builder.message("service plan visibility id must be specified");
        }
        return builder.build();
    }

    public static UpdateServicePlanVisibilityRequestBuilder builder() {
        return new UpdateServicePlanVisibilityRequestBuilder();
    }

    @JsonProperty(value="organization_guid")
    public String getOrganizationId() {
        return this.organizationId;
    }

    @JsonProperty(value="service_plan_guid")
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    @JsonIgnore
    public String getServicePlanVisibilityId() {
        return this.servicePlanVisibilityId;
    }

    public static class UpdateServicePlanVisibilityRequestBuilder {
        private String organizationId;
        private String servicePlanId;
        private String servicePlanVisibilityId;

        UpdateServicePlanVisibilityRequestBuilder() {
        }

        public UpdateServicePlanVisibilityRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public UpdateServicePlanVisibilityRequestBuilder servicePlanId(String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        public UpdateServicePlanVisibilityRequestBuilder servicePlanVisibilityId(String servicePlanVisibilityId) {
            this.servicePlanVisibilityId = servicePlanVisibilityId;
            return this;
        }

        public UpdateServicePlanVisibilityRequest build() {
            return new UpdateServicePlanVisibilityRequest(this.organizationId, this.servicePlanId, this.servicePlanVisibilityId);
        }

        public String toString() {
            return "UpdateServicePlanVisibilityRequest.UpdateServicePlanVisibilityRequestBuilder(organizationId=" + this.organizationId + ", servicePlanId=" + this.servicePlanId + ", servicePlanVisibilityId=" + this.servicePlanVisibilityId + ")";
        }
    }
}

