/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class DeleteServiceRequest
implements Validatable {
    private final Boolean async;
    private final Boolean purge;
    private final String serviceId;

    DeleteServiceRequest(Boolean async, Boolean purge, String serviceId) {
        this.async = async;
        this.purge = purge;
        this.serviceId = serviceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceId == null) {
            builder.message("service id must be specified");
        }
        return builder.build();
    }

    public static DeleteServiceRequestBuilder builder() {
        return new DeleteServiceRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteServiceRequest)) {
            return false;
        }
        DeleteServiceRequest other = (DeleteServiceRequest)o;
        Boolean this$async = this.getAsync();
        Boolean other$async = other.getAsync();
        if (this$async == null ? other$async != null : !((Object)this$async).equals(other$async)) {
            return false;
        }
        Boolean this$purge = this.getPurge();
        Boolean other$purge = other.getPurge();
        if (this$purge == null ? other$purge != null : !((Object)this$purge).equals(other$purge)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        return !(this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $async = this.getAsync();
        result = result * 59 + ($async == null ? 43 : ((Object)$async).hashCode());
        Boolean $purge = this.getPurge();
        result = result * 59 + ($purge == null ? 43 : ((Object)$purge).hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        return result;
    }

    public String toString() {
        return "DeleteServiceRequest(async=" + this.getAsync() + ", purge=" + this.getPurge() + ", serviceId=" + this.getServiceId() + ")";
    }

    @QueryParameter(value="async")
    public Boolean getAsync() {
        return this.async;
    }

    @QueryParameter(value="purge")
    public Boolean getPurge() {
        return this.purge;
    }

    @JsonIgnore
    public String getServiceId() {
        return this.serviceId;
    }

    public static class DeleteServiceRequestBuilder {
        private Boolean async;
        private Boolean purge;
        private String serviceId;

        DeleteServiceRequestBuilder() {
        }

        public DeleteServiceRequestBuilder async(Boolean async) {
            this.async = async;
            return this;
        }

        public DeleteServiceRequestBuilder purge(Boolean purge) {
            this.purge = purge;
            return this;
        }

        public DeleteServiceRequestBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public DeleteServiceRequest build() {
            return new DeleteServiceRequest(this.async, this.purge, this.serviceId);
        }

        public String toString() {
            return "DeleteServiceRequest.DeleteServiceRequestBuilder(async=" + this.async + ", purge=" + this.purge + ", serviceId=" + this.serviceId + ")";
        }
    }
}

