/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListServiceServicePlansRequest
extends PaginatedRequest
implements Validatable {
    private final Boolean active;
    private final List<String> serviceBrokerIds;
    private final String serviceId;
    private final List<String> serviceInstanceIds;

    ListServiceServicePlansRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, Boolean active, List<String> serviceBrokerIds, String serviceId, List<String> serviceInstanceIds) {
        super(orderDirection, page, resultsPerPage);
        this.active = active;
        this.serviceBrokerIds = serviceBrokerIds;
        this.serviceId = serviceId;
        this.serviceInstanceIds = serviceInstanceIds;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceId == null) {
            builder.message("service id must be specified");
        }
        return builder.build();
    }

    public static ListServiceServicePlansRequestBuilder builder() {
        return new ListServiceServicePlansRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListServiceServicePlansRequest)) {
            return false;
        }
        ListServiceServicePlansRequest other = (ListServiceServicePlansRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        List<String> this$serviceBrokerIds = this.getServiceBrokerIds();
        List<String> other$serviceBrokerIds = other.getServiceBrokerIds();
        if (this$serviceBrokerIds == null ? other$serviceBrokerIds != null : !((Object)this$serviceBrokerIds).equals(other$serviceBrokerIds)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        List<String> this$serviceInstanceIds = this.getServiceInstanceIds();
        List<String> other$serviceInstanceIds = other.getServiceInstanceIds();
        return !(this$serviceInstanceIds == null ? other$serviceInstanceIds != null : !((Object)this$serviceInstanceIds).equals(other$serviceInstanceIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListServiceServicePlansRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        List<String> $serviceBrokerIds = this.getServiceBrokerIds();
        result = result * 59 + ($serviceBrokerIds == null ? 43 : ((Object)$serviceBrokerIds).hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        List<String> $serviceInstanceIds = this.getServiceInstanceIds();
        result = result * 59 + ($serviceInstanceIds == null ? 43 : ((Object)$serviceInstanceIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListServiceServicePlansRequest(super=" + super.toString() + ", active=" + this.getActive() + ", serviceBrokerIds=" + this.getServiceBrokerIds() + ", serviceId=" + this.getServiceId() + ", serviceInstanceIds=" + this.getServiceInstanceIds() + ")";
    }

    @InFilterParameter(value="active")
    public Boolean getActive() {
        return this.active;
    }

    @InFilterParameter(value="service_broker_guid")
    public List<String> getServiceBrokerIds() {
        return this.serviceBrokerIds;
    }

    @JsonIgnore
    public String getServiceId() {
        return this.serviceId;
    }

    @InFilterParameter(value="service_instance_guid")
    public List<String> getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }

    public static class ListServiceServicePlansRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private Boolean active;
        private ArrayList<String> serviceBrokerIds;
        private String serviceId;
        private ArrayList<String> serviceInstanceIds;

        ListServiceServicePlansRequestBuilder() {
        }

        public ListServiceServicePlansRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListServiceServicePlansRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListServiceServicePlansRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListServiceServicePlansRequestBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public ListServiceServicePlansRequestBuilder serviceBrokerId(String serviceBrokerId) {
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList();
            }
            this.serviceBrokerIds.add(serviceBrokerId);
            return this;
        }

        public ListServiceServicePlansRequestBuilder serviceBrokerIds(Collection<? extends String> serviceBrokerIds) {
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList();
            }
            this.serviceBrokerIds.addAll(serviceBrokerIds);
            return this;
        }

        public ListServiceServicePlansRequestBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public ListServiceServicePlansRequestBuilder serviceInstanceId(String serviceInstanceId) {
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList();
            }
            this.serviceInstanceIds.add(serviceInstanceId);
            return this;
        }

        public ListServiceServicePlansRequestBuilder serviceInstanceIds(Collection<? extends String> serviceInstanceIds) {
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList();
            }
            this.serviceInstanceIds.addAll(serviceInstanceIds);
            return this;
        }

        public ListServiceServicePlansRequest build() {
            List<String> serviceInstanceIds;
            List<String> serviceBrokerIds;
            switch (this.serviceBrokerIds == null ? 0 : this.serviceBrokerIds.size()) {
                case 0: {
                    serviceBrokerIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceBrokerIds = Collections.singletonList(this.serviceBrokerIds.get(0));
                    break;
                }
                default: {
                    serviceBrokerIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceBrokerIds));
                }
            }
            switch (this.serviceInstanceIds == null ? 0 : this.serviceInstanceIds.size()) {
                case 0: {
                    serviceInstanceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceInstanceIds = Collections.singletonList(this.serviceInstanceIds.get(0));
                    break;
                }
                default: {
                    serviceInstanceIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceInstanceIds));
                }
            }
            return new ListServiceServicePlansRequest(this.orderDirection, this.page, this.resultsPerPage, this.active, serviceBrokerIds, this.serviceId, serviceInstanceIds);
        }

        public String toString() {
            return "ListServiceServicePlansRequest.ListServiceServicePlansRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", active=" + this.active + ", serviceBrokerIds=" + this.serviceBrokerIds + ", serviceId=" + this.serviceId + ", serviceInstanceIds=" + this.serviceInstanceIds + ")";
        }
    }
}

