/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListServicesRequest
extends PaginatedRequest
implements Validatable {
    private final Boolean active;
    private final List<String> labels;
    private final List<String> providers;
    private final List<String> serviceBrokerIds;

    ListServicesRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, Boolean active, List<String> labels, List<String> providers, List<String> serviceBrokerIds) {
        super(orderDirection, page, resultsPerPage);
        this.active = active;
        this.labels = labels;
        this.providers = providers;
        this.serviceBrokerIds = serviceBrokerIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    public static ListServicesRequestBuilder builder() {
        return new ListServicesRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListServicesRequest)) {
            return false;
        }
        ListServicesRequest other = (ListServicesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        List<String> this$labels = this.getLabels();
        List<String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        List<String> this$providers = this.getProviders();
        List<String> other$providers = other.getProviders();
        if (this$providers == null ? other$providers != null : !((Object)this$providers).equals(other$providers)) {
            return false;
        }
        List<String> this$serviceBrokerIds = this.getServiceBrokerIds();
        List<String> other$serviceBrokerIds = other.getServiceBrokerIds();
        return !(this$serviceBrokerIds == null ? other$serviceBrokerIds != null : !((Object)this$serviceBrokerIds).equals(other$serviceBrokerIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListServicesRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        List<String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        List<String> $providers = this.getProviders();
        result = result * 59 + ($providers == null ? 43 : ((Object)$providers).hashCode());
        List<String> $serviceBrokerIds = this.getServiceBrokerIds();
        result = result * 59 + ($serviceBrokerIds == null ? 43 : ((Object)$serviceBrokerIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListServicesRequest(super=" + super.toString() + ", active=" + this.getActive() + ", labels=" + this.getLabels() + ", providers=" + this.getProviders() + ", serviceBrokerIds=" + this.getServiceBrokerIds() + ")";
    }

    @InFilterParameter(value="active")
    public Boolean getActive() {
        return this.active;
    }

    @InFilterParameter(value="label")
    public List<String> getLabels() {
        return this.labels;
    }

    @InFilterParameter(value="provider")
    public List<String> getProviders() {
        return this.providers;
    }

    @InFilterParameter(value="service_broker_guid")
    public List<String> getServiceBrokerIds() {
        return this.serviceBrokerIds;
    }

    public static class ListServicesRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private Boolean active;
        private ArrayList<String> labels;
        private ArrayList<String> providers;
        private ArrayList<String> serviceBrokerIds;

        ListServicesRequestBuilder() {
        }

        public ListServicesRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListServicesRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListServicesRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListServicesRequestBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public ListServicesRequestBuilder label(String label) {
            if (this.labels == null) {
                this.labels = new ArrayList();
            }
            this.labels.add(label);
            return this;
        }

        public ListServicesRequestBuilder labels(Collection<? extends String> labels) {
            if (this.labels == null) {
                this.labels = new ArrayList();
            }
            this.labels.addAll(labels);
            return this;
        }

        public ListServicesRequestBuilder provider(String provider) {
            if (this.providers == null) {
                this.providers = new ArrayList();
            }
            this.providers.add(provider);
            return this;
        }

        public ListServicesRequestBuilder providers(Collection<? extends String> providers) {
            if (this.providers == null) {
                this.providers = new ArrayList();
            }
            this.providers.addAll(providers);
            return this;
        }

        public ListServicesRequestBuilder serviceBrokerId(String serviceBrokerId) {
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList();
            }
            this.serviceBrokerIds.add(serviceBrokerId);
            return this;
        }

        public ListServicesRequestBuilder serviceBrokerIds(Collection<? extends String> serviceBrokerIds) {
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList();
            }
            this.serviceBrokerIds.addAll(serviceBrokerIds);
            return this;
        }

        public ListServicesRequest build() {
            List<String> serviceBrokerIds;
            List<String> providers;
            List<String> labels;
            switch (this.labels == null ? 0 : this.labels.size()) {
                case 0: {
                    labels = Collections.emptyList();
                    break;
                }
                case 1: {
                    labels = Collections.singletonList(this.labels.get(0));
                    break;
                }
                default: {
                    labels = Collections.unmodifiableList(new ArrayList<String>(this.labels));
                }
            }
            switch (this.providers == null ? 0 : this.providers.size()) {
                case 0: {
                    providers = Collections.emptyList();
                    break;
                }
                case 1: {
                    providers = Collections.singletonList(this.providers.get(0));
                    break;
                }
                default: {
                    providers = Collections.unmodifiableList(new ArrayList<String>(this.providers));
                }
            }
            switch (this.serviceBrokerIds == null ? 0 : this.serviceBrokerIds.size()) {
                case 0: {
                    serviceBrokerIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceBrokerIds = Collections.singletonList(this.serviceBrokerIds.get(0));
                    break;
                }
                default: {
                    serviceBrokerIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceBrokerIds));
                }
            }
            return new ListServicesRequest(this.orderDirection, this.page, this.resultsPerPage, this.active, labels, providers, serviceBrokerIds);
        }

        public String toString() {
            return "ListServicesRequest.ListServicesRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", active=" + this.active + ", labels=" + this.labels + ", providers=" + this.providers + ", serviceBrokerIds=" + this.serviceBrokerIds + ")";
        }
    }
}

