/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.services;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.services.ServiceResource;

public final class ListServicesResponse
extends PaginatedResponse<ServiceResource> {
    ListServicesResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<ServiceResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListServicesResponseBuilder builder() {
        return new ListServicesResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListServicesResponse)) {
            return false;
        }
        ListServicesResponse other = (ListServicesResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListServicesResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListServicesResponse(super=" + super.toString() + ")";
    }

    public static class ListServicesResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<ServiceResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListServicesResponseBuilder() {
        }

        public ListServicesResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListServicesResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListServicesResponseBuilder resource(ServiceResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListServicesResponseBuilder resources(Collection<? extends ServiceResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListServicesResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListServicesResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListServicesResponse build() {
            List<ServiceResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<ServiceResource>(this.resources));
                }
            }
            return new ListServicesResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListServicesResponse.ListServicesResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

