/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.services;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class ServiceEntity {
    private final Boolean active;
    private final Boolean bindable;
    private final String description;
    private final String documentationUrl;
    private final String extra;
    private final String infoUrl;
    private final String label;
    private final String longDescription;
    private final Boolean planUpdateable;
    private final String provider;
    private final List<String> requires;
    private final String serviceBrokerId;
    private final String servicePlansUrl;
    private final List<String> tags;
    private final String uniqueId;
    private final String url;
    private final String version;

    ServiceEntity(@JsonProperty(value="active") Boolean active, @JsonProperty(value="bindable") Boolean bindable, @JsonProperty(value="description") String description, @JsonProperty(value="documentation_url") @Deprecated String documentationUrl, @JsonProperty(value="extra") String extra, @JsonProperty(value="info_url") @Deprecated String infoUrl, @JsonProperty(value="label") String label, @JsonProperty(value="long_description") @Deprecated String longDescription, @JsonProperty(value="plan_updateable") Boolean planUpdateable, @JsonProperty(value="provider") @Deprecated String provider, @JsonProperty(value="requires") List<String> requires, @JsonProperty(value="service_broker_guid") String serviceBrokerId, @JsonProperty(value="service_plans_url") String servicePlansUrl, @JsonProperty(value="tags") List<String> tags, @JsonProperty(value="unique_id") String uniqueId, @JsonProperty(value="url") @Deprecated String url, @JsonProperty(value="version") @Deprecated String version) {
        this.active = active;
        this.bindable = bindable;
        this.description = description;
        this.documentationUrl = documentationUrl;
        this.extra = extra;
        this.infoUrl = infoUrl;
        this.label = label;
        this.longDescription = longDescription;
        this.planUpdateable = planUpdateable;
        this.provider = provider;
        this.requires = Optional.ofNullable(requires).orElse(Collections.emptyList());
        this.serviceBrokerId = serviceBrokerId;
        this.servicePlansUrl = servicePlansUrl;
        this.tags = Optional.ofNullable(tags).orElse(Collections.emptyList());
        this.uniqueId = uniqueId;
        this.url = url;
        this.version = version;
    }

    public static ServiceEntityBuilder builder() {
        return new ServiceEntityBuilder();
    }

    public Boolean getActive() {
        return this.active;
    }

    public Boolean getBindable() {
        return this.bindable;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExtra() {
        return this.extra;
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getPlanUpdateable() {
        return this.planUpdateable;
    }

    public List<String> getRequires() {
        return this.requires;
    }

    public String getServiceBrokerId() {
        return this.serviceBrokerId;
    }

    public String getServicePlansUrl() {
        return this.servicePlansUrl;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceEntity)) {
            return false;
        }
        ServiceEntity other = (ServiceEntity)o;
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Boolean this$bindable = this.getBindable();
        Boolean other$bindable = other.getBindable();
        if (this$bindable == null ? other$bindable != null : !((Object)this$bindable).equals(other$bindable)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$documentationUrl = this.getDocumentationUrl();
        String other$documentationUrl = other.getDocumentationUrl();
        if (this$documentationUrl == null ? other$documentationUrl != null : !this$documentationUrl.equals(other$documentationUrl)) {
            return false;
        }
        String this$extra = this.getExtra();
        String other$extra = other.getExtra();
        if (this$extra == null ? other$extra != null : !this$extra.equals(other$extra)) {
            return false;
        }
        String this$infoUrl = this.getInfoUrl();
        String other$infoUrl = other.getInfoUrl();
        if (this$infoUrl == null ? other$infoUrl != null : !this$infoUrl.equals(other$infoUrl)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$longDescription = this.getLongDescription();
        String other$longDescription = other.getLongDescription();
        if (this$longDescription == null ? other$longDescription != null : !this$longDescription.equals(other$longDescription)) {
            return false;
        }
        Boolean this$planUpdateable = this.getPlanUpdateable();
        Boolean other$planUpdateable = other.getPlanUpdateable();
        if (this$planUpdateable == null ? other$planUpdateable != null : !((Object)this$planUpdateable).equals(other$planUpdateable)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        List<String> this$requires = this.getRequires();
        List<String> other$requires = other.getRequires();
        if (this$requires == null ? other$requires != null : !((Object)this$requires).equals(other$requires)) {
            return false;
        }
        String this$serviceBrokerId = this.getServiceBrokerId();
        String other$serviceBrokerId = other.getServiceBrokerId();
        if (this$serviceBrokerId == null ? other$serviceBrokerId != null : !this$serviceBrokerId.equals(other$serviceBrokerId)) {
            return false;
        }
        String this$servicePlansUrl = this.getServicePlansUrl();
        String other$servicePlansUrl = other.getServicePlansUrl();
        if (this$servicePlansUrl == null ? other$servicePlansUrl != null : !this$servicePlansUrl.equals(other$servicePlansUrl)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$uniqueId = this.getUniqueId();
        String other$uniqueId = other.getUniqueId();
        if (this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Boolean $bindable = this.getBindable();
        result = result * 59 + ($bindable == null ? 43 : ((Object)$bindable).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $documentationUrl = this.getDocumentationUrl();
        result = result * 59 + ($documentationUrl == null ? 43 : $documentationUrl.hashCode());
        String $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
        String $infoUrl = this.getInfoUrl();
        result = result * 59 + ($infoUrl == null ? 43 : $infoUrl.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $longDescription = this.getLongDescription();
        result = result * 59 + ($longDescription == null ? 43 : $longDescription.hashCode());
        Boolean $planUpdateable = this.getPlanUpdateable();
        result = result * 59 + ($planUpdateable == null ? 43 : ((Object)$planUpdateable).hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        List<String> $requires = this.getRequires();
        result = result * 59 + ($requires == null ? 43 : ((Object)$requires).hashCode());
        String $serviceBrokerId = this.getServiceBrokerId();
        result = result * 59 + ($serviceBrokerId == null ? 43 : $serviceBrokerId.hashCode());
        String $servicePlansUrl = this.getServicePlansUrl();
        result = result * 59 + ($servicePlansUrl == null ? 43 : $servicePlansUrl.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $uniqueId = this.getUniqueId();
        result = result * 59 + ($uniqueId == null ? 43 : $uniqueId.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    public String toString() {
        return "ServiceEntity(active=" + this.getActive() + ", bindable=" + this.getBindable() + ", description=" + this.getDescription() + ", documentationUrl=" + this.getDocumentationUrl() + ", extra=" + this.getExtra() + ", infoUrl=" + this.getInfoUrl() + ", label=" + this.getLabel() + ", longDescription=" + this.getLongDescription() + ", planUpdateable=" + this.getPlanUpdateable() + ", provider=" + this.getProvider() + ", requires=" + this.getRequires() + ", serviceBrokerId=" + this.getServiceBrokerId() + ", servicePlansUrl=" + this.getServicePlansUrl() + ", tags=" + this.getTags() + ", uniqueId=" + this.getUniqueId() + ", url=" + this.getUrl() + ", version=" + this.getVersion() + ")";
    }

    @Deprecated
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    @Deprecated
    public String getInfoUrl() {
        return this.infoUrl;
    }

    @Deprecated
    public String getLongDescription() {
        return this.longDescription;
    }

    @Deprecated
    public String getProvider() {
        return this.provider;
    }

    @Deprecated
    public String getUrl() {
        return this.url;
    }

    @Deprecated
    public String getVersion() {
        return this.version;
    }

    public static class ServiceEntityBuilder {
        private Boolean active;
        private Boolean bindable;
        private String description;
        private String documentationUrl;
        private String extra;
        private String infoUrl;
        private String label;
        private String longDescription;
        private Boolean planUpdateable;
        private String provider;
        private ArrayList<String> requires;
        private String serviceBrokerId;
        private String servicePlansUrl;
        private ArrayList<String> tags;
        private String uniqueId;
        private String url;
        private String version;

        ServiceEntityBuilder() {
        }

        public ServiceEntityBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public ServiceEntityBuilder bindable(Boolean bindable) {
            this.bindable = bindable;
            return this;
        }

        public ServiceEntityBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ServiceEntityBuilder documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public ServiceEntityBuilder extra(String extra) {
            this.extra = extra;
            return this;
        }

        public ServiceEntityBuilder infoUrl(String infoUrl) {
            this.infoUrl = infoUrl;
            return this;
        }

        public ServiceEntityBuilder label(String label) {
            this.label = label;
            return this;
        }

        public ServiceEntityBuilder longDescription(String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        public ServiceEntityBuilder planUpdateable(Boolean planUpdateable) {
            this.planUpdateable = planUpdateable;
            return this;
        }

        public ServiceEntityBuilder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public ServiceEntityBuilder require(String require) {
            if (this.requires == null) {
                this.requires = new ArrayList();
            }
            this.requires.add(require);
            return this;
        }

        public ServiceEntityBuilder requires(Collection<? extends String> requires) {
            if (this.requires == null) {
                this.requires = new ArrayList();
            }
            this.requires.addAll(requires);
            return this;
        }

        public ServiceEntityBuilder serviceBrokerId(String serviceBrokerId) {
            this.serviceBrokerId = serviceBrokerId;
            return this;
        }

        public ServiceEntityBuilder servicePlansUrl(String servicePlansUrl) {
            this.servicePlansUrl = servicePlansUrl;
            return this;
        }

        public ServiceEntityBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public ServiceEntityBuilder tags(Collection<? extends String> tags) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public ServiceEntityBuilder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public ServiceEntityBuilder url(String url) {
            this.url = url;
            return this;
        }

        public ServiceEntityBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ServiceEntity build() {
            List<String> tags;
            List<String> requires;
            switch (this.requires == null ? 0 : this.requires.size()) {
                case 0: {
                    requires = Collections.emptyList();
                    break;
                }
                case 1: {
                    requires = Collections.singletonList(this.requires.get(0));
                    break;
                }
                default: {
                    requires = Collections.unmodifiableList(new ArrayList<String>(this.requires));
                }
            }
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<String>(this.tags));
                }
            }
            return new ServiceEntity(this.active, this.bindable, this.description, this.documentationUrl, this.extra, this.infoUrl, this.label, this.longDescription, this.planUpdateable, this.provider, requires, this.serviceBrokerId, this.servicePlansUrl, tags, this.uniqueId, this.url, this.version);
        }

        public String toString() {
            return "ServiceEntity.ServiceEntityBuilder(active=" + this.active + ", bindable=" + this.bindable + ", description=" + this.description + ", documentationUrl=" + this.documentationUrl + ", extra=" + this.extra + ", infoUrl=" + this.infoUrl + ", label=" + this.label + ", longDescription=" + this.longDescription + ", planUpdateable=" + this.planUpdateable + ", provider=" + this.provider + ", requires=" + this.requires + ", serviceBrokerId=" + this.serviceBrokerId + ", servicePlansUrl=" + this.servicePlansUrl + ", tags=" + this.tags + ", uniqueId=" + this.uniqueId + ", url=" + this.url + ", version=" + this.version + ")";
        }
    }
}

