/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceusageevents;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListServiceUsageEventsRequest
extends PaginatedRequest
implements Validatable {
    private final String afterServiceUsageEventId;
    private final List<String> serviceIds;
    private final List<String> serviceInstanceTypes;

    ListServiceUsageEventsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, String afterServiceUsageEventId, List<String> serviceIds, List<String> serviceInstanceTypes) {
        super(orderDirection, page, resultsPerPage);
        this.afterServiceUsageEventId = afterServiceUsageEventId;
        this.serviceIds = serviceIds;
        this.serviceInstanceTypes = serviceInstanceTypes;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    public static ListServiceUsageEventsRequestBuilder builder() {
        return new ListServiceUsageEventsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListServiceUsageEventsRequest)) {
            return false;
        }
        ListServiceUsageEventsRequest other = (ListServiceUsageEventsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$afterServiceUsageEventId = this.getAfterServiceUsageEventId();
        String other$afterServiceUsageEventId = other.getAfterServiceUsageEventId();
        if (this$afterServiceUsageEventId == null ? other$afterServiceUsageEventId != null : !this$afterServiceUsageEventId.equals(other$afterServiceUsageEventId)) {
            return false;
        }
        List<String> this$serviceIds = this.getServiceIds();
        List<String> other$serviceIds = other.getServiceIds();
        if (this$serviceIds == null ? other$serviceIds != null : !((Object)this$serviceIds).equals(other$serviceIds)) {
            return false;
        }
        List<String> this$serviceInstanceTypes = this.getServiceInstanceTypes();
        List<String> other$serviceInstanceTypes = other.getServiceInstanceTypes();
        return !(this$serviceInstanceTypes == null ? other$serviceInstanceTypes != null : !((Object)this$serviceInstanceTypes).equals(other$serviceInstanceTypes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListServiceUsageEventsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $afterServiceUsageEventId = this.getAfterServiceUsageEventId();
        result = result * 59 + ($afterServiceUsageEventId == null ? 43 : $afterServiceUsageEventId.hashCode());
        List<String> $serviceIds = this.getServiceIds();
        result = result * 59 + ($serviceIds == null ? 43 : ((Object)$serviceIds).hashCode());
        List<String> $serviceInstanceTypes = this.getServiceInstanceTypes();
        result = result * 59 + ($serviceInstanceTypes == null ? 43 : ((Object)$serviceInstanceTypes).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListServiceUsageEventsRequest(super=" + super.toString() + ", afterServiceUsageEventId=" + this.getAfterServiceUsageEventId() + ", serviceIds=" + this.getServiceIds() + ", serviceInstanceTypes=" + this.getServiceInstanceTypes() + ")";
    }

    @QueryParameter(value="after_guid")
    public String getAfterServiceUsageEventId() {
        return this.afterServiceUsageEventId;
    }

    @InFilterParameter(value="service_guid")
    public List<String> getServiceIds() {
        return this.serviceIds;
    }

    @InFilterParameter(value="service_instance_type")
    public List<String> getServiceInstanceTypes() {
        return this.serviceInstanceTypes;
    }

    public static class ListServiceUsageEventsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private String afterServiceUsageEventId;
        private ArrayList<String> serviceIds;
        private ArrayList<String> serviceInstanceTypes;

        ListServiceUsageEventsRequestBuilder() {
        }

        public ListServiceUsageEventsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListServiceUsageEventsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListServiceUsageEventsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListServiceUsageEventsRequestBuilder afterServiceUsageEventId(String afterServiceUsageEventId) {
            this.afterServiceUsageEventId = afterServiceUsageEventId;
            return this;
        }

        public ListServiceUsageEventsRequestBuilder serviceId(String serviceId) {
            if (this.serviceIds == null) {
                this.serviceIds = new ArrayList();
            }
            this.serviceIds.add(serviceId);
            return this;
        }

        public ListServiceUsageEventsRequestBuilder serviceIds(Collection<? extends String> serviceIds) {
            if (this.serviceIds == null) {
                this.serviceIds = new ArrayList();
            }
            this.serviceIds.addAll(serviceIds);
            return this;
        }

        public ListServiceUsageEventsRequestBuilder serviceInstanceType(String serviceInstanceType) {
            if (this.serviceInstanceTypes == null) {
                this.serviceInstanceTypes = new ArrayList();
            }
            this.serviceInstanceTypes.add(serviceInstanceType);
            return this;
        }

        public ListServiceUsageEventsRequestBuilder serviceInstanceTypes(Collection<? extends String> serviceInstanceTypes) {
            if (this.serviceInstanceTypes == null) {
                this.serviceInstanceTypes = new ArrayList();
            }
            this.serviceInstanceTypes.addAll(serviceInstanceTypes);
            return this;
        }

        public ListServiceUsageEventsRequest build() {
            List<String> serviceInstanceTypes;
            List<String> serviceIds;
            switch (this.serviceIds == null ? 0 : this.serviceIds.size()) {
                case 0: {
                    serviceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceIds = Collections.singletonList(this.serviceIds.get(0));
                    break;
                }
                default: {
                    serviceIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceIds));
                }
            }
            switch (this.serviceInstanceTypes == null ? 0 : this.serviceInstanceTypes.size()) {
                case 0: {
                    serviceInstanceTypes = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceInstanceTypes = Collections.singletonList(this.serviceInstanceTypes.get(0));
                    break;
                }
                default: {
                    serviceInstanceTypes = Collections.unmodifiableList(new ArrayList<String>(this.serviceInstanceTypes));
                }
            }
            return new ListServiceUsageEventsRequest(this.orderDirection, this.page, this.resultsPerPage, this.afterServiceUsageEventId, serviceIds, serviceInstanceTypes);
        }

        public String toString() {
            return "ListServiceUsageEventsRequest.ListServiceUsageEventsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", afterServiceUsageEventId=" + this.afterServiceUsageEventId + ", serviceIds=" + this.serviceIds + ", serviceInstanceTypes=" + this.serviceInstanceTypes + ")";
        }
    }
}

