/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.shareddomains;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CreateSharedDomainRequest
implements Validatable {
    private final String name;
    private final String routerGroupId;

    CreateSharedDomainRequest(String name, String routerGroupId) {
        this.name = name;
        this.routerGroupId = routerGroupId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        return builder.build();
    }

    public static CreateSharedDomainRequestBuilder builder() {
        return new CreateSharedDomainRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateSharedDomainRequest)) {
            return false;
        }
        CreateSharedDomainRequest other = (CreateSharedDomainRequest)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$routerGroupId = this.getRouterGroupId();
        String other$routerGroupId = other.getRouterGroupId();
        return !(this$routerGroupId == null ? other$routerGroupId != null : !this$routerGroupId.equals(other$routerGroupId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $routerGroupId = this.getRouterGroupId();
        result = result * 59 + ($routerGroupId == null ? 43 : $routerGroupId.hashCode());
        return result;
    }

    public String toString() {
        return "CreateSharedDomainRequest(name=" + this.getName() + ", routerGroupId=" + this.getRouterGroupId() + ")";
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="router_group_guid")
    public String getRouterGroupId() {
        return this.routerGroupId;
    }

    public static class CreateSharedDomainRequestBuilder {
        private String name;
        private String routerGroupId;

        CreateSharedDomainRequestBuilder() {
        }

        public CreateSharedDomainRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateSharedDomainRequestBuilder routerGroupId(String routerGroupId) {
            this.routerGroupId = routerGroupId;
            return this;
        }

        public CreateSharedDomainRequest build() {
            return new CreateSharedDomainRequest(this.name, this.routerGroupId);
        }

        public String toString() {
            return "CreateSharedDomainRequest.CreateSharedDomainRequestBuilder(name=" + this.name + ", routerGroupId=" + this.routerGroupId + ")";
        }
    }
}

