/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spacequotadefinitions;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.spacequotadefinitions.SpaceQuotaDefinitionResource;

public final class ListSpaceQuotaDefinitionsResponse
extends PaginatedResponse<SpaceQuotaDefinitionResource> {
    ListSpaceQuotaDefinitionsResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<SpaceQuotaDefinitionResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListSpaceQuotaDefinitionsResponseBuilder builder() {
        return new ListSpaceQuotaDefinitionsResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListSpaceQuotaDefinitionsResponse)) {
            return false;
        }
        ListSpaceQuotaDefinitionsResponse other = (ListSpaceQuotaDefinitionsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListSpaceQuotaDefinitionsResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListSpaceQuotaDefinitionsResponse(super=" + super.toString() + ")";
    }

    public static class ListSpaceQuotaDefinitionsResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<SpaceQuotaDefinitionResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListSpaceQuotaDefinitionsResponseBuilder() {
        }

        public ListSpaceQuotaDefinitionsResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListSpaceQuotaDefinitionsResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListSpaceQuotaDefinitionsResponseBuilder resource(SpaceQuotaDefinitionResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListSpaceQuotaDefinitionsResponseBuilder resources(Collection<? extends SpaceQuotaDefinitionResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListSpaceQuotaDefinitionsResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListSpaceQuotaDefinitionsResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListSpaceQuotaDefinitionsResponse build() {
            List<SpaceQuotaDefinitionResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<SpaceQuotaDefinitionResource>(this.resources));
                }
            }
            return new ListSpaceQuotaDefinitionsResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListSpaceQuotaDefinitionsResponse.ListSpaceQuotaDefinitionsResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

