/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spacequotadefinitions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class RemoveSpaceQuotaDefinitionRequest
implements Validatable {
    private final String spaceId;
    private final String spaceQuotaDefinitionId;

    RemoveSpaceQuotaDefinitionRequest(String spaceId, String spaceQuotaDefinitionId) {
        this.spaceId = spaceId;
        this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        if (this.spaceQuotaDefinitionId == null) {
            builder.message("space quota definition id must be specified");
        }
        return builder.build();
    }

    public static RemoveSpaceQuotaDefinitionRequestBuilder builder() {
        return new RemoveSpaceQuotaDefinitionRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveSpaceQuotaDefinitionRequest)) {
            return false;
        }
        RemoveSpaceQuotaDefinitionRequest other = (RemoveSpaceQuotaDefinitionRequest)o;
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) {
            return false;
        }
        String this$spaceQuotaDefinitionId = this.getSpaceQuotaDefinitionId();
        String other$spaceQuotaDefinitionId = other.getSpaceQuotaDefinitionId();
        return !(this$spaceQuotaDefinitionId == null ? other$spaceQuotaDefinitionId != null : !this$spaceQuotaDefinitionId.equals(other$spaceQuotaDefinitionId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        String $spaceQuotaDefinitionId = this.getSpaceQuotaDefinitionId();
        result = result * 59 + ($spaceQuotaDefinitionId == null ? 43 : $spaceQuotaDefinitionId.hashCode());
        return result;
    }

    public String toString() {
        return "RemoveSpaceQuotaDefinitionRequest(spaceId=" + this.getSpaceId() + ", spaceQuotaDefinitionId=" + this.getSpaceQuotaDefinitionId() + ")";
    }

    @JsonIgnore
    public String getSpaceId() {
        return this.spaceId;
    }

    @JsonIgnore
    public String getSpaceQuotaDefinitionId() {
        return this.spaceQuotaDefinitionId;
    }

    public static class RemoveSpaceQuotaDefinitionRequestBuilder {
        private String spaceId;
        private String spaceQuotaDefinitionId;

        RemoveSpaceQuotaDefinitionRequestBuilder() {
        }

        public RemoveSpaceQuotaDefinitionRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public RemoveSpaceQuotaDefinitionRequestBuilder spaceQuotaDefinitionId(String spaceQuotaDefinitionId) {
            this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
            return this;
        }

        public RemoveSpaceQuotaDefinitionRequest build() {
            return new RemoveSpaceQuotaDefinitionRequest(this.spaceId, this.spaceQuotaDefinitionId);
        }

        public String toString() {
            return "RemoveSpaceQuotaDefinitionRequest.RemoveSpaceQuotaDefinitionRequestBuilder(spaceId=" + this.spaceId + ", spaceQuotaDefinitionId=" + this.spaceQuotaDefinitionId + ")";
        }
    }
}

