/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class AssociateSpaceAuditorRequest
implements Validatable {
    private final String auditorId;
    private final String spaceId;

    AssociateSpaceAuditorRequest(String auditorId, String spaceId) {
        this.auditorId = auditorId;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.auditorId == null) {
            builder.message("auditor id must be specified");
        }
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static AssociateSpaceAuditorRequestBuilder builder() {
        return new AssociateSpaceAuditorRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssociateSpaceAuditorRequest)) {
            return false;
        }
        AssociateSpaceAuditorRequest other = (AssociateSpaceAuditorRequest)o;
        String this$auditorId = this.getAuditorId();
        String other$auditorId = other.getAuditorId();
        if (this$auditorId == null ? other$auditorId != null : !this$auditorId.equals(other$auditorId)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        return !(this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $auditorId = this.getAuditorId();
        result = result * 59 + ($auditorId == null ? 43 : $auditorId.hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    public String toString() {
        return "AssociateSpaceAuditorRequest(auditorId=" + this.getAuditorId() + ", spaceId=" + this.getSpaceId() + ")";
    }

    @JsonIgnore
    public String getAuditorId() {
        return this.auditorId;
    }

    @JsonIgnore
    public String getSpaceId() {
        return this.spaceId;
    }

    public static class AssociateSpaceAuditorRequestBuilder {
        private String auditorId;
        private String spaceId;

        AssociateSpaceAuditorRequestBuilder() {
        }

        public AssociateSpaceAuditorRequestBuilder auditorId(String auditorId) {
            this.auditorId = auditorId;
            return this;
        }

        public AssociateSpaceAuditorRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public AssociateSpaceAuditorRequest build() {
            return new AssociateSpaceAuditorRequest(this.auditorId, this.spaceId);
        }

        public String toString() {
            return "AssociateSpaceAuditorRequest.AssociateSpaceAuditorRequestBuilder(auditorId=" + this.auditorId + ", spaceId=" + this.spaceId + ")";
        }
    }
}

