/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class AssociateSpaceManagerByUsernameRequest
implements Validatable {
    private final String spaceId;
    private final String username;

    AssociateSpaceManagerByUsernameRequest(String spaceId, String username) {
        this.spaceId = spaceId;
        this.username = username;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        if (this.username == null) {
            builder.message("username must be specified");
        }
        return builder.build();
    }

    public static AssociateSpaceManagerByUsernameRequestBuilder builder() {
        return new AssociateSpaceManagerByUsernameRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssociateSpaceManagerByUsernameRequest)) {
            return false;
        }
        AssociateSpaceManagerByUsernameRequest other = (AssociateSpaceManagerByUsernameRequest)o;
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        return !(this$username == null ? other$username != null : !this$username.equals(other$username));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        return result;
    }

    public String toString() {
        return "AssociateSpaceManagerByUsernameRequest(spaceId=" + this.getSpaceId() + ", username=" + this.getUsername() + ")";
    }

    @JsonIgnore
    public String getSpaceId() {
        return this.spaceId;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    public static class AssociateSpaceManagerByUsernameRequestBuilder {
        private String spaceId;
        private String username;

        AssociateSpaceManagerByUsernameRequestBuilder() {
        }

        public AssociateSpaceManagerByUsernameRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public AssociateSpaceManagerByUsernameRequestBuilder username(String username) {
            this.username = username;
            return this;
        }

        public AssociateSpaceManagerByUsernameRequest build() {
            return new AssociateSpaceManagerByUsernameRequest(this.spaceId, this.username);
        }

        public String toString() {
            return "AssociateSpaceManagerByUsernameRequest.AssociateSpaceManagerByUsernameRequestBuilder(spaceId=" + this.spaceId + ", username=" + this.username + ")";
        }
    }
}

