/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class AssociateSpaceManagerRequest
implements Validatable {
    private final String managerId;
    private final String spaceId;

    AssociateSpaceManagerRequest(String managerId, String spaceId) {
        this.managerId = managerId;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.managerId == null) {
            builder.message("manager id must be specified");
        }
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static AssociateSpaceManagerRequestBuilder builder() {
        return new AssociateSpaceManagerRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssociateSpaceManagerRequest)) {
            return false;
        }
        AssociateSpaceManagerRequest other = (AssociateSpaceManagerRequest)o;
        String this$managerId = this.getManagerId();
        String other$managerId = other.getManagerId();
        if (this$managerId == null ? other$managerId != null : !this$managerId.equals(other$managerId)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        return !(this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $managerId = this.getManagerId();
        result = result * 59 + ($managerId == null ? 43 : $managerId.hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    public String toString() {
        return "AssociateSpaceManagerRequest(managerId=" + this.getManagerId() + ", spaceId=" + this.getSpaceId() + ")";
    }

    @JsonIgnore
    public String getManagerId() {
        return this.managerId;
    }

    @JsonIgnore
    public String getSpaceId() {
        return this.spaceId;
    }

    public static class AssociateSpaceManagerRequestBuilder {
        private String managerId;
        private String spaceId;

        AssociateSpaceManagerRequestBuilder() {
        }

        public AssociateSpaceManagerRequestBuilder managerId(String managerId) {
            this.managerId = managerId;
            return this;
        }

        public AssociateSpaceManagerRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public AssociateSpaceManagerRequest build() {
            return new AssociateSpaceManagerRequest(this.managerId, this.spaceId);
        }

        public String toString() {
            return "AssociateSpaceManagerRequest.AssociateSpaceManagerRequestBuilder(managerId=" + this.managerId + ", spaceId=" + this.spaceId + ")";
        }
    }
}

