/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class AssociateSpaceSecurityGroupRequest
implements Validatable {
    private final String securityGroupId;
    private final String spaceId;

    AssociateSpaceSecurityGroupRequest(String securityGroupId, String spaceId) {
        this.securityGroupId = securityGroupId;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.securityGroupId == null) {
            builder.message("security group id must be specified");
        }
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static AssociateSpaceSecurityGroupRequestBuilder builder() {
        return new AssociateSpaceSecurityGroupRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssociateSpaceSecurityGroupRequest)) {
            return false;
        }
        AssociateSpaceSecurityGroupRequest other = (AssociateSpaceSecurityGroupRequest)o;
        String this$securityGroupId = this.getSecurityGroupId();
        String other$securityGroupId = other.getSecurityGroupId();
        if (this$securityGroupId == null ? other$securityGroupId != null : !this$securityGroupId.equals(other$securityGroupId)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        return !(this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $securityGroupId = this.getSecurityGroupId();
        result = result * 59 + ($securityGroupId == null ? 43 : $securityGroupId.hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    public String toString() {
        return "AssociateSpaceSecurityGroupRequest(securityGroupId=" + this.getSecurityGroupId() + ", spaceId=" + this.getSpaceId() + ")";
    }

    @JsonIgnore
    public String getSecurityGroupId() {
        return this.securityGroupId;
    }

    @JsonIgnore
    public String getSpaceId() {
        return this.spaceId;
    }

    public static class AssociateSpaceSecurityGroupRequestBuilder {
        private String securityGroupId;
        private String spaceId;

        AssociateSpaceSecurityGroupRequestBuilder() {
        }

        public AssociateSpaceSecurityGroupRequestBuilder securityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        public AssociateSpaceSecurityGroupRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public AssociateSpaceSecurityGroupRequest build() {
            return new AssociateSpaceSecurityGroupRequest(this.securityGroupId, this.spaceId);
        }

        public String toString() {
            return "AssociateSpaceSecurityGroupRequest.AssociateSpaceSecurityGroupRequestBuilder(securityGroupId=" + this.securityGroupId + ", spaceId=" + this.spaceId + ")";
        }
    }
}

