/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CreateSpaceRequest
implements Validatable {
    private final Boolean allowSsh;
    private final List<String> auditorIds;
    private final List<String> developerIds;
    private final List<String> domainIds;
    private final List<String> managerIds;
    private final String name;
    private final String organizationId;
    private final List<String> securityGroupIds;
    private final String spaceQuotaDefinitionId;

    CreateSpaceRequest(Boolean allowSsh, List<String> auditorIds, List<String> developerIds, List<String> domainIds, List<String> managerIds, String name, String organizationId, List<String> securityGroupIds, String spaceQuotaDefinitionId) {
        this.allowSsh = allowSsh;
        this.auditorIds = auditorIds;
        this.developerIds = developerIds;
        this.domainIds = domainIds;
        this.managerIds = managerIds;
        this.name = name;
        this.organizationId = organizationId;
        this.securityGroupIds = securityGroupIds;
        this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    public static CreateSpaceRequestBuilder builder() {
        return new CreateSpaceRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateSpaceRequest)) {
            return false;
        }
        CreateSpaceRequest other = (CreateSpaceRequest)o;
        Boolean this$allowSsh = this.getAllowSsh();
        Boolean other$allowSsh = other.getAllowSsh();
        if (this$allowSsh == null ? other$allowSsh != null : !((Object)this$allowSsh).equals(other$allowSsh)) {
            return false;
        }
        List<String> this$auditorIds = this.getAuditorIds();
        List<String> other$auditorIds = other.getAuditorIds();
        if (this$auditorIds == null ? other$auditorIds != null : !((Object)this$auditorIds).equals(other$auditorIds)) {
            return false;
        }
        List<String> this$developerIds = this.getDeveloperIds();
        List<String> other$developerIds = other.getDeveloperIds();
        if (this$developerIds == null ? other$developerIds != null : !((Object)this$developerIds).equals(other$developerIds)) {
            return false;
        }
        List<String> this$domainIds = this.getDomainIds();
        List<String> other$domainIds = other.getDomainIds();
        if (this$domainIds == null ? other$domainIds != null : !((Object)this$domainIds).equals(other$domainIds)) {
            return false;
        }
        List<String> this$managerIds = this.getManagerIds();
        List<String> other$managerIds = other.getManagerIds();
        if (this$managerIds == null ? other$managerIds != null : !((Object)this$managerIds).equals(other$managerIds)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        List<String> this$securityGroupIds = this.getSecurityGroupIds();
        List<String> other$securityGroupIds = other.getSecurityGroupIds();
        if (this$securityGroupIds == null ? other$securityGroupIds != null : !((Object)this$securityGroupIds).equals(other$securityGroupIds)) {
            return false;
        }
        String this$spaceQuotaDefinitionId = this.getSpaceQuotaDefinitionId();
        String other$spaceQuotaDefinitionId = other.getSpaceQuotaDefinitionId();
        return !(this$spaceQuotaDefinitionId == null ? other$spaceQuotaDefinitionId != null : !this$spaceQuotaDefinitionId.equals(other$spaceQuotaDefinitionId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $allowSsh = this.getAllowSsh();
        result = result * 59 + ($allowSsh == null ? 43 : ((Object)$allowSsh).hashCode());
        List<String> $auditorIds = this.getAuditorIds();
        result = result * 59 + ($auditorIds == null ? 43 : ((Object)$auditorIds).hashCode());
        List<String> $developerIds = this.getDeveloperIds();
        result = result * 59 + ($developerIds == null ? 43 : ((Object)$developerIds).hashCode());
        List<String> $domainIds = this.getDomainIds();
        result = result * 59 + ($domainIds == null ? 43 : ((Object)$domainIds).hashCode());
        List<String> $managerIds = this.getManagerIds();
        result = result * 59 + ($managerIds == null ? 43 : ((Object)$managerIds).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        List<String> $securityGroupIds = this.getSecurityGroupIds();
        result = result * 59 + ($securityGroupIds == null ? 43 : ((Object)$securityGroupIds).hashCode());
        String $spaceQuotaDefinitionId = this.getSpaceQuotaDefinitionId();
        result = result * 59 + ($spaceQuotaDefinitionId == null ? 43 : $spaceQuotaDefinitionId.hashCode());
        return result;
    }

    public String toString() {
        return "CreateSpaceRequest(allowSsh=" + this.getAllowSsh() + ", auditorIds=" + this.getAuditorIds() + ", developerIds=" + this.getDeveloperIds() + ", domainIds=" + this.getDomainIds() + ", managerIds=" + this.getManagerIds() + ", name=" + this.getName() + ", organizationId=" + this.getOrganizationId() + ", securityGroupIds=" + this.getSecurityGroupIds() + ", spaceQuotaDefinitionId=" + this.getSpaceQuotaDefinitionId() + ")";
    }

    @JsonProperty(value="allow_ssh")
    public Boolean getAllowSsh() {
        return this.allowSsh;
    }

    @JsonProperty(value="auditor_guid")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getAuditorIds() {
        return this.auditorIds;
    }

    @JsonProperty(value="developer_guid")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getDeveloperIds() {
        return this.developerIds;
    }

    @JsonProperty(value="domain_guid")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getDomainIds() {
        return this.domainIds;
    }

    @JsonProperty(value="manager_guid")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getManagerIds() {
        return this.managerIds;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="organization_guid")
    public String getOrganizationId() {
        return this.organizationId;
    }

    @JsonProperty(value="security_group_guids")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    @JsonProperty(value="space quota definition guid")
    public String getSpaceQuotaDefinitionId() {
        return this.spaceQuotaDefinitionId;
    }

    public static class CreateSpaceRequestBuilder {
        private Boolean allowSsh;
        private ArrayList<String> auditorIds;
        private ArrayList<String> developerIds;
        private ArrayList<String> domainIds;
        private ArrayList<String> managerIds;
        private String name;
        private String organizationId;
        private ArrayList<String> securityGroupIds;
        private String spaceQuotaDefinitionId;

        CreateSpaceRequestBuilder() {
        }

        public CreateSpaceRequestBuilder allowSsh(Boolean allowSsh) {
            this.allowSsh = allowSsh;
            return this;
        }

        public CreateSpaceRequestBuilder auditorId(String auditorId) {
            if (this.auditorIds == null) {
                this.auditorIds = new ArrayList();
            }
            this.auditorIds.add(auditorId);
            return this;
        }

        public CreateSpaceRequestBuilder auditorIds(Collection<? extends String> auditorIds) {
            if (this.auditorIds == null) {
                this.auditorIds = new ArrayList();
            }
            this.auditorIds.addAll(auditorIds);
            return this;
        }

        public CreateSpaceRequestBuilder developerId(String developerId) {
            if (this.developerIds == null) {
                this.developerIds = new ArrayList();
            }
            this.developerIds.add(developerId);
            return this;
        }

        public CreateSpaceRequestBuilder developerIds(Collection<? extends String> developerIds) {
            if (this.developerIds == null) {
                this.developerIds = new ArrayList();
            }
            this.developerIds.addAll(developerIds);
            return this;
        }

        public CreateSpaceRequestBuilder domainId(String domainId) {
            if (this.domainIds == null) {
                this.domainIds = new ArrayList();
            }
            this.domainIds.add(domainId);
            return this;
        }

        public CreateSpaceRequestBuilder domainIds(Collection<? extends String> domainIds) {
            if (this.domainIds == null) {
                this.domainIds = new ArrayList();
            }
            this.domainIds.addAll(domainIds);
            return this;
        }

        public CreateSpaceRequestBuilder managerId(String managerId) {
            if (this.managerIds == null) {
                this.managerIds = new ArrayList();
            }
            this.managerIds.add(managerId);
            return this;
        }

        public CreateSpaceRequestBuilder managerIds(Collection<? extends String> managerIds) {
            if (this.managerIds == null) {
                this.managerIds = new ArrayList();
            }
            this.managerIds.addAll(managerIds);
            return this;
        }

        public CreateSpaceRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateSpaceRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public CreateSpaceRequestBuilder securityGroupId(String securityGroupId) {
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new ArrayList();
            }
            this.securityGroupIds.add(securityGroupId);
            return this;
        }

        public CreateSpaceRequestBuilder securityGroupIds(Collection<? extends String> securityGroupIds) {
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new ArrayList();
            }
            this.securityGroupIds.addAll(securityGroupIds);
            return this;
        }

        public CreateSpaceRequestBuilder spaceQuotaDefinitionId(String spaceQuotaDefinitionId) {
            this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
            return this;
        }

        public CreateSpaceRequest build() {
            List<String> securityGroupIds;
            List<String> managerIds;
            List<String> domainIds;
            List<String> developerIds;
            List<String> auditorIds;
            switch (this.auditorIds == null ? 0 : this.auditorIds.size()) {
                case 0: {
                    auditorIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    auditorIds = Collections.singletonList(this.auditorIds.get(0));
                    break;
                }
                default: {
                    auditorIds = Collections.unmodifiableList(new ArrayList<String>(this.auditorIds));
                }
            }
            switch (this.developerIds == null ? 0 : this.developerIds.size()) {
                case 0: {
                    developerIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    developerIds = Collections.singletonList(this.developerIds.get(0));
                    break;
                }
                default: {
                    developerIds = Collections.unmodifiableList(new ArrayList<String>(this.developerIds));
                }
            }
            switch (this.domainIds == null ? 0 : this.domainIds.size()) {
                case 0: {
                    domainIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    domainIds = Collections.singletonList(this.domainIds.get(0));
                    break;
                }
                default: {
                    domainIds = Collections.unmodifiableList(new ArrayList<String>(this.domainIds));
                }
            }
            switch (this.managerIds == null ? 0 : this.managerIds.size()) {
                case 0: {
                    managerIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    managerIds = Collections.singletonList(this.managerIds.get(0));
                    break;
                }
                default: {
                    managerIds = Collections.unmodifiableList(new ArrayList<String>(this.managerIds));
                }
            }
            switch (this.securityGroupIds == null ? 0 : this.securityGroupIds.size()) {
                case 0: {
                    securityGroupIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    securityGroupIds = Collections.singletonList(this.securityGroupIds.get(0));
                    break;
                }
                default: {
                    securityGroupIds = Collections.unmodifiableList(new ArrayList<String>(this.securityGroupIds));
                }
            }
            return new CreateSpaceRequest(this.allowSsh, auditorIds, developerIds, domainIds, managerIds, this.name, this.organizationId, securityGroupIds, this.spaceQuotaDefinitionId);
        }

        public String toString() {
            return "CreateSpaceRequest.CreateSpaceRequestBuilder(allowSsh=" + this.allowSsh + ", auditorIds=" + this.auditorIds + ", developerIds=" + this.developerIds + ", domainIds=" + this.domainIds + ", managerIds=" + this.managerIds + ", name=" + this.name + ", organizationId=" + this.organizationId + ", securityGroupIds=" + this.securityGroupIds + ", spaceQuotaDefinitionId=" + this.spaceQuotaDefinitionId + ")";
        }
    }
}

